/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.bean;

import cn.yzw.infra.component.fss.model.request.PreviewBatchRequest;
import cn.yzw.infra.component.fss.model.response.PreviewMultiResponse;
import cn.yzw.infra.component.fss.util.Base64Util;
import cn.yzw.infra.component.fss.util.JsonUtils;
import cn.yzw.infra.component.fss.util.SecureUtil;
import cn.yzw.infra.component.tenant.context.TenantHolder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FssRpcClient {
    private boolean tenantOpen;
    private String appName;
    private String appSecret;

    public FssRpcClient(String appName, String secret, boolean tenantOpen) {
        this.appName = appName;
        this.appSecret = secret;
        this.tenantOpen = tenantOpen;
    }

    public final PreviewMultiResponse signUrl(PreviewBatchRequest previewBatchRequest, Map<String, String> ... headers) throws Exception {
        Assert.notEmpty((Object[])previewBatchRequest.getFilePaths(), (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        this.initCommonParams(headers);
        ReferenceConfig reference = new ReferenceConfig();
        reference.setInterface("cn.yzw.fss.common.service.share.FileShareFacade");
        reference.setVersion("1.0.0");
        reference.setGeneric("true");
        ReferenceConfigCache referenceConfigCache = ReferenceConfigCache.getCache();
        GenericService genericService = (GenericService)referenceConfigCache.get((ReferenceConfigBase)reference);
        String clazz = "cn.yzw.fss.common.service.share.model.ShareReqDto";
        Map request = JsonUtils.convertToMap(previewBatchRequest);
        request.put("class", clazz);
        Object result = genericService.$invoke("share", new String[]{clazz}, new Object[]{request});
        return JsonUtils.convertToBean(result, PreviewMultiResponse.class);
    }

    private void initCommonParams(Map<String, String>[] headers) {
        String tenantId;
        String access = Base64Util.encodeStr(this.appName.getBytes(StandardCharsets.UTF_8), false, true);
        String token = SecureUtil.generateRandom(10);
        String expires = System.currentTimeMillis() + "";
        TreeMap<String, String> signParams = new TreeMap<String, String>();
        signParams.put("access", access);
        signParams.put("appSecret", SecureUtil.decrypt(this.appName, this.appSecret));
        signParams.put("expires", expires);
        signParams.put("x-token", token);
        String sign = SecureUtil.encodeSign(signParams);
        RpcContext.getContext().setAttachment("access", access);
        RpcContext.getContext().setAttachment("expires", expires);
        RpcContext.getContext().setAttachment("x-token", token);
        RpcContext.getContext().setAttachment("sign", sign);
        RpcContext.getContext().setAttachment("x-fss-origin", "5");
        RpcContext.getContext().setAttachment("x-fss-uuid", UUID.randomUUID().toString());
        if (headers != null && headers.length > 0 && headers[0] != null) {
            for (String key : headers[0].keySet()) {
                RpcContext.getContext().setAttachment(key, headers[0].get(key));
            }
        }
        if (this.tenantOpen && !StringUtils.hasText((String)(tenantId = RpcContext.getContext().getAttachment("tenant-id")))) {
            tenantId = TenantHolder.INSTANCE.getTenantId();
            if (!StringUtils.hasText((String)tenantId)) {
                throw new IllegalArgumentException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            RpcContext.getContext().setAttachment("tenant-id", tenantId);
        }
    }
}

