/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.crypto;

import cn.yzw.infra.component.fss.crypto.CipherWrapper;
import cn.yzw.infra.component.fss.util.Base64Util;
import cn.yzw.infra.component.fss.util.HexUtil;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FssAesCrypt {
    private CipherWrapper wrapper;
    private SecretKey secretKey;
    private final Lock lock = new ReentrantLock();

    public FssAesCrypt(String algorithm, byte[] key, byte[] iv) {
        this.init(algorithm, key, iv);
    }

    public FssAesCrypt init(String algorithm, byte[] key, byte[] iv) {
        IvParameterSpec parameterSpec;
        this.secretKey = new SecretKeySpec(key, "AES");
        this.wrapper = new CipherWrapper(algorithm);
        IvParameterSpec ivParameterSpec = parameterSpec = iv == null || iv.length == 0 ? null : new IvParameterSpec(iv);
        if (parameterSpec != null) {
            this.wrapper.setParams(parameterSpec);
            return this;
        }
        byte[] ivs = Optional.ofNullable(this.wrapper).map(CipherWrapper::getCipher).map(Cipher::getIV).get();
        parameterSpec = null != ivs ? new IvParameterSpec(ivs) : parameterSpec;
        this.wrapper.setParams(parameterSpec);
        return this;
    }

    public String decryptStr(String data, Charset charset) {
        byte[] encryptData = HexUtil.isHex(data) ? HexUtil.decodeHex(data) : Base64Util.decode(data);
        return new String(this.decrypt(encryptData), charset);
    }

    public byte[] decrypt(byte[] bytes) {
        this.lock.lock();
        try {
            Cipher cipher = this.wrapper.initMode(2, this.secretKey).getCipher();
            byte[] byArray = cipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

