/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.intercept;

import cn.yzw.infra.component.fss.bean.FssClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogListener
extends EventListener {
    private static final Logger log = LoggerFactory.getLogger(FssClient.class);
    private Long dnsStart = 0L;
    private Long connectStart = 0L;
    private Long callStart = 0L;
    private Long connectAcquire = 0L;
    private Long secureConnectStart = 0L;
    private Long responseBodyStart = 0L;

    public void callStart(Call call) {
        long start = System.currentTimeMillis();
        this.callStart = start;
        log.info("-------> callStart\uff08\u5f00\u59cb\u8bf7\u6c42\uff09, startTime: {}", (Object)start);
    }

    public void dnsStart(Call call, String domainName) {
        long start = System.currentTimeMillis();
        this.dnsStart = start;
        log.info("-------> dnsStart\uff08DNS\u89e3\u6790\u5f00\u59cb\uff09,domainName: {}, startTime: {}", (Object)domainName, (Object)start);
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        log.info("-------> dnsEnd\uff08DNS\u89e3\u6790\u7ed3\u675f\uff09,domainName: {}, \u57df\u540d\u89e3\u6790\u8017\u65f6\uff08ms\uff09: {}", (Object)domainName, (Object)(System.currentTimeMillis() - this.dnsStart));
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        long start = System.currentTimeMillis();
        this.connectStart = start;
        log.info("-------> connectStart\uff08\u8fde\u63a5\u5f00\u59cb\uff09,hostname: {}, startTime: {}", (Object)inetSocketAddress.getHostName(), (Object)start);
    }

    public void secureConnectStart(Call call) {
        long start = System.currentTimeMillis();
        this.secureConnectStart = start;
        log.info("-------> secureConnectStart\uff08\u5efa\u7acbTSL\u5b89\u5168\u94fe\u63a5\u5f00\u59cb\uff09, startTime: {}", (Object)start);
    }

    public void secureConnectEnd(Call call, @Nullable Handshake handshake) {
        log.info("-------> dnsEnd\uff08\u5efa\u7acbTSL\u5b89\u5168\u94fe\u63a5\u7ed3\u675f\uff09, \u8017\u65f6\uff08ms\uff09: {}", (Object)(System.currentTimeMillis() - this.secureConnectStart));
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        log.info("-------> connectEnd\uff08\u94fe\u63a5\u5efa\u7acb\u7ed3\u675f\uff09, \u5efa\u7acb\u8fde\u63a5\u8017\u65f6\uff08ms\uff09: {}", (Object)(System.currentTimeMillis() - this.connectStart));
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException ioe) {
        log.info("-------> connectFailed\uff08\u8fde\u63a5\u5efa\u7acb\u5931\u8d25\uff09, \u8017\u65f6\uff08ms\uff09: {}", (Object)(System.currentTimeMillis() - this.connectStart), (Object)ioe);
    }

    public void connectionAcquired(Call call, Connection connection) {
        long start = System.currentTimeMillis();
        this.connectAcquire = start;
        log.info("-------> connectionAcquired\uff08\u8fde\u63a5\u83b7\u53d6\u5f00\u59cb\uff09, startTime: {}", (Object)start);
    }

    public void connectionReleased(Call call, Connection connection) {
        log.info("-------> connectionReleased\uff08\u8fde\u63a5\u91ca\u653e\uff09, \u8fde\u63a5\u4fdd\u6301\u65f6\u957f\uff08ms\uff09: {}", (Object)(System.currentTimeMillis() - this.connectAcquire));
    }

    public void requestHeadersStart(Call call) {
        log.info("-------> requestHeadersStart, startTime: {}", (Object)System.currentTimeMillis());
    }

    public void requestHeadersEnd(Call call, Request request) {
        log.info("-------> requestHeadersEnd, endTime: {}", (Object)System.currentTimeMillis());
    }

    public void requestBodyStart(Call call) {
        log.info("-------> requestBodyStart, startTime: {}", (Object)System.currentTimeMillis());
    }

    public void requestBodyEnd(Call call, long byteCount) {
        log.info("-------> requestBodyEnd, endTime: {}, byteCount: {}", (Object)System.currentTimeMillis(), (Object)byteCount);
    }

    public void requestFailed(Call call, IOException ioe) {
        log.info("-------> requestFailed, endTime: {}", (Object)System.currentTimeMillis(), (Object)ioe);
    }

    public void responseHeadersStart(Call call) {
        log.info("-------> responseHeadersStart, startTime: {}", (Object)System.currentTimeMillis());
    }

    public void responseHeadersEnd(Call call, Response response) {
        log.info("-------> responseHeadersEnd, endTime: {}", (Object)System.currentTimeMillis());
    }

    public void responseBodyStart(Call call) {
        long start = System.currentTimeMillis();
        this.responseBodyStart = start;
        log.info("-------> responseBodyStart, startTime: {}", (Object)start);
    }

    public void responseBodyEnd(Call call, long byteCount) {
        log.info("-------> responseBodyEnd, \u8017\u65f6\uff08ms\uff09: {}, byteCount: {}", (Object)(System.currentTimeMillis() - this.responseBodyStart), (Object)byteCount);
    }

    public void responseFailed(Call call, IOException ioe) {
        log.info("-------> responseFailed, \u8017\u65f6\uff08ms\uff09: {}", (Object)(System.currentTimeMillis() - this.responseBodyStart), (Object)ioe);
    }

    public void callEnd(Call call) {
        log.info("-------> callEnd\uff08\u8bf7\u6c42\u7ed3\u675f\uff09\uff0c\u8017\u65f6\uff08ms\uff09: {}", (Object)(System.currentTimeMillis() - this.callStart));
    }

    public void callFailed(Call call, IOException ioe) {
        log.info("-------> callFailed\uff08\u8bf7\u6c42\u7ed3\u675f\uff1a\u5931\u8d25\uff09\uff0c\u8017\u65f6\uff08ms\uff09: {}", (Object)(System.currentTimeMillis() - this.callStart));
    }
}

