/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Processor;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KeyedProcessor
implements JsonpSerializable {
    @Nullable
    private final Processor stats;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<KeyedProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeyedProcessor::setupKeyedProcessorDeserializer);

    private KeyedProcessor(Builder builder) {
        this.stats = builder.stats;
        this.type = builder.type;
    }

    public static KeyedProcessor of(Function<Builder, ObjectBuilder<KeyedProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Processor stats() {
        return this.stats;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.stats != null) {
            generator.writeKey("stats");
            this.stats.serialize(generator, mapper);
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    protected static void setupKeyedProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::stats, Processor._DESERIALIZER, "stats");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<KeyedProcessor> {
        @Nullable
        private Processor stats;
        @Nullable
        private String type;

        public final Builder stats(@Nullable Processor value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.stats(fn.apply(new Processor.Builder()).build());
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        public KeyedProcessor build() {
            this._checkSingleUse();
            return new KeyedProcessor(this);
        }
    }
}

