/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.event.NacosDiscoveryInfoChangedEvent;
import com.alibaba.cloud.nacos.utils.InetIPv6Util;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.spring.util.PropertySourcesUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="spring.cloud.nacos.discovery")
public class NacosDiscoveryProperties {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryProperties.class);
    public static final String PREFIX = "spring.cloud.nacos.discovery";
    private static final Pattern PATTERN = Pattern.compile("-(\\w)");
    private String serverAddr;
    private String username;
    private String password;
    private String endpoint;
    private String namespace;
    private long watchDelay = 30000L;
    private String logName;
    @Value(value="${spring.cloud.nacos.discovery.service:${spring.application.name:}}")
    private String service;
    private float weight = 1.0f;
    private String clusterName = "DEFAULT";
    private String group = "DEFAULT_GROUP";
    private String namingLoadCacheAtStart = "false";
    private Map<String, String> metadata = new HashMap<String, String>();
    private boolean registerEnabled = true;
    private String ip;
    private String networkInterface = "";
    private String ipType = "IPv4";
    private int port = -1;
    private boolean secure = false;
    private String accessKey;
    private String secretKey;
    private Integer heartBeatInterval;
    private Integer heartBeatTimeout;
    private Integer ipDeleteTimeout;
    private boolean instanceEnabled = true;
    private boolean ephemeral = true;
    private boolean failureToleranceEnabled;
    private boolean failFast = true;
    @Autowired
    private InetIPv6Util inetIPv6Util;
    @Autowired
    private InetUtils inetUtils;
    @Autowired
    private Environment environment;
    @Autowired
    private NacosServiceManager nacosServiceManager;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    public void init() throws Exception {
        this.metadata.put("preserved.register.source", "SPRING_CLOUD");
        if (this.secure) {
            this.metadata.put("secure", "true");
        }
        this.serverAddr = Objects.toString(this.serverAddr, "");
        if (this.serverAddr.endsWith("/")) {
            this.serverAddr = this.serverAddr.substring(0, this.serverAddr.length() - 1);
        }
        this.endpoint = Objects.toString(this.endpoint, "");
        this.namespace = Objects.toString(this.namespace, "");
        this.logName = Objects.toString(this.logName, "");
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            if (StringUtils.isEmpty((CharSequence)this.networkInterface)) {
                if ("IPv4".equalsIgnoreCase(this.ipType)) {
                    this.ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                } else {
                    if (!"IPv6".equalsIgnoreCase(this.ipType)) throw new IllegalArgumentException("please checking the type of IP " + this.ipType);
                    this.ip = this.inetIPv6Util.findIPv6Address();
                }
            } else {
                NetworkInterface netInterface = NetworkInterface.getByName(this.networkInterface);
                if (null == netInterface) {
                    throw new IllegalArgumentException("no such interface " + this.networkInterface);
                }
                Enumeration<InetAddress> inetAddress = netInterface.getInetAddresses();
                while (inetAddress.hasMoreElements()) {
                    InetAddress currentAddress = inetAddress.nextElement();
                    if (!(currentAddress instanceof Inet4Address) && (!(currentAddress instanceof Inet6Address) || currentAddress.isLoopbackAddress())) continue;
                    this.ip = currentAddress.getHostAddress();
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)this.ip)) {
                    throw new RuntimeException("cannot find available ip from network interface " + this.networkInterface);
                }
            }
        }
        this.overrideFromEnv(this.environment);
        if (this.nacosServiceManager.isNacosDiscoveryInfoChanged(this)) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new NacosDiscoveryInfoChangedEvent(this));
        }
        this.nacosServiceManager.setNacosDiscoveryProperties(this);
    }

    @Deprecated
    public NamingService namingServiceInstance() {
        return this.nacosServiceManager.getNamingService();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public void setInetUtils(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIpType() {
        return this.ipType;
    }

    public void setIpType(String ipType) {
        this.ipType = ipType;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Integer getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatInterval(Integer heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public Integer getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatTimeout(Integer heartBeatTimeout) {
        this.heartBeatTimeout = heartBeatTimeout;
    }

    public Integer getIpDeleteTimeout() {
        return this.ipDeleteTimeout;
    }

    public void setIpDeleteTimeout(Integer ipDeleteTimeout) {
        this.ipDeleteTimeout = ipDeleteTimeout;
    }

    public String getNamingLoadCacheAtStart() {
        return this.namingLoadCacheAtStart;
    }

    public void setNamingLoadCacheAtStart(String namingLoadCacheAtStart) {
        this.namingLoadCacheAtStart = namingLoadCacheAtStart;
    }

    public long getWatchDelay() {
        return this.watchDelay;
    }

    public void setWatchDelay(long watchDelay) {
        this.watchDelay = watchDelay;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isInstanceEnabled() {
        return this.instanceEnabled;
    }

    public void setInstanceEnabled(boolean instanceEnabled) {
        this.instanceEnabled = instanceEnabled;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    public boolean isFailureToleranceEnabled() {
        return this.failureToleranceEnabled;
    }

    public void setFailureToleranceEnabled(boolean failureToleranceEnabled) {
        this.failureToleranceEnabled = failureToleranceEnabled;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NacosDiscoveryProperties that = (NacosDiscoveryProperties)o;
        return this.watchDelay == that.watchDelay && Float.compare(that.weight, this.weight) == 0 && this.registerEnabled == that.registerEnabled && this.port == that.port && this.secure == that.secure && this.instanceEnabled == that.instanceEnabled && this.ephemeral == that.ephemeral && this.failureToleranceEnabled == that.failureToleranceEnabled && Objects.equals(this.serverAddr, that.serverAddr) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.logName, that.logName) && Objects.equals(this.service, that.service) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.group, that.group) && Objects.equals(this.namingLoadCacheAtStart, that.namingLoadCacheAtStart) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ip, that.ip) && Objects.equals(this.networkInterface, that.networkInterface) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey) && Objects.equals(this.heartBeatInterval, that.heartBeatInterval) && Objects.equals(this.heartBeatTimeout, that.heartBeatTimeout) && Objects.equals(this.failFast, that.failFast) && Objects.equals(this.ipDeleteTimeout, that.ipDeleteTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.serverAddr, this.username, this.password, this.endpoint, this.namespace, this.watchDelay, this.logName, this.service, Float.valueOf(this.weight), this.clusterName, this.group, this.namingLoadCacheAtStart, this.metadata, this.registerEnabled, this.ip, this.networkInterface, this.port, this.secure, this.accessKey, this.secretKey, this.heartBeatInterval, this.heartBeatTimeout, this.ipDeleteTimeout, this.instanceEnabled, this.ephemeral, this.failureToleranceEnabled, this.failFast);
    }

    public String toString() {
        return "NacosDiscoveryProperties{serverAddr='" + this.serverAddr + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", endpoint='" + this.endpoint + '\'' + ", namespace='" + this.namespace + '\'' + ", watchDelay=" + this.watchDelay + ", logName='" + this.logName + '\'' + ", service='" + this.service + '\'' + ", weight=" + this.weight + ", clusterName='" + this.clusterName + '\'' + ", group='" + this.group + '\'' + ", namingLoadCacheAtStart='" + this.namingLoadCacheAtStart + '\'' + ", metadata=" + this.metadata + ", registerEnabled=" + this.registerEnabled + ", ip='" + this.ip + '\'' + ", networkInterface='" + this.networkInterface + '\'' + ", port=" + this.port + ", secure=" + this.secure + ", accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", heartBeatInterval=" + this.heartBeatInterval + ", heartBeatTimeout=" + this.heartBeatTimeout + ", ipDeleteTimeout=" + this.ipDeleteTimeout + ", instanceEnabled=" + this.instanceEnabled + ", ephemeral=" + this.ephemeral + ", failureToleranceEnabled=" + this.failureToleranceEnabled + '}' + ", ipDeleteTimeout=" + this.ipDeleteTimeout + ", failFast=" + this.failFast + '}';
    }

    public void overrideFromEnv(Environment env) {
        if (StringUtils.isEmpty((CharSequence)this.getServerAddr())) {
            String serverAddr = env.resolvePlaceholders("${spring.cloud.nacos.discovery.server-addr:}");
            if (StringUtils.isEmpty((CharSequence)serverAddr)) {
                serverAddr = env.resolvePlaceholders("${spring.cloud.nacos.server-addr:127.0.0.1:8848}");
            }
            this.setServerAddr(serverAddr);
        }
        if (StringUtils.isEmpty((CharSequence)this.getNamespace())) {
            this.setNamespace(env.resolvePlaceholders("${spring.cloud.nacos.discovery.namespace:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getAccessKey())) {
            this.setAccessKey(env.resolvePlaceholders("${spring.cloud.nacos.discovery.access-key:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getSecretKey())) {
            this.setSecretKey(env.resolvePlaceholders("${spring.cloud.nacos.discovery.secret-key:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getLogName())) {
            this.setLogName(env.resolvePlaceholders("${spring.cloud.nacos.discovery.log-name:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getClusterName())) {
            this.setClusterName(env.resolvePlaceholders("${spring.cloud.nacos.discovery.cluster-name:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getEndpoint())) {
            this.setEndpoint(env.resolvePlaceholders("${spring.cloud.nacos.discovery.endpoint:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getGroup())) {
            this.setGroup(env.resolvePlaceholders("${spring.cloud.nacos.discovery.group:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getUsername())) {
            this.setUsername(env.resolvePlaceholders("${spring.cloud.nacos.username:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getPassword())) {
            this.setPassword(env.resolvePlaceholders("${spring.cloud.nacos.password:}"));
        }
    }

    public Properties getNacosProperties() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("username", Objects.toString(this.username, ""));
        properties.put("password", Objects.toString(this.password, ""));
        properties.put("namespace", this.namespace);
        properties.put("com.alibaba.nacos.naming.log.filename", this.logName);
        if (this.endpoint.contains(":")) {
            int index = this.endpoint.indexOf(":");
            properties.put("endpoint", this.endpoint.substring(0, index));
            properties.put("endpointPort", this.endpoint.substring(index + 1));
        } else {
            properties.put("endpoint", this.endpoint);
        }
        properties.put("accessKey", this.accessKey);
        properties.put("secretKey", this.secretKey);
        properties.put("clusterName", this.clusterName);
        properties.put("namingLoadCacheAtStart", this.namingLoadCacheAtStart);
        this.enrichNacosDiscoveryProperties(properties);
        return properties;
    }

    private void enrichNacosDiscoveryProperties(Properties nacosDiscoveryProperties) {
        Map properties = PropertySourcesUtils.getSubProperties((ConfigurableEnvironment)((ConfigurableEnvironment)this.environment), (String)PREFIX);
        properties.forEach((k, v) -> nacosDiscoveryProperties.putIfAbsent(this.resolveKey((String)k), String.valueOf(v)));
    }

    private String resolveKey(String key) {
        Matcher matcher = PATTERN.matcher(key);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

