/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.impl;

import com.alipay.sofa.jraft.FSMCaller;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.conf.ConfigurationEntry;
import com.alipay.sofa.jraft.conf.ConfigurationManager;
import com.alipay.sofa.jraft.core.NodeMetrics;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.option.LogManagerOptions;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.LogManager;
import com.alipay.sofa.jraft.storage.LogStorage;
import com.alipay.sofa.jraft.util.ArrayDequeue;
import com.alipay.sofa.jraft.util.LogExceptionHandler;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogManagerImpl
implements LogManager {
    private static final Logger LOG = LoggerFactory.getLogger(LogManagerImpl.class);
    private LogStorage logStorage;
    private ConfigurationManager configManager;
    private FSMCaller fsmCaller;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();
    private volatile boolean stopped;
    private volatile boolean hasError;
    private long nextWaitId;
    private LogId diskId = new LogId(0L, 0L);
    private LogId appliedId = new LogId(0L, 0L);
    private ArrayDequeue<LogEntry> logsInMemory = new ArrayDequeue();
    private volatile long firstLogIndex;
    private volatile long lastLogIndex;
    private volatile LogId lastSnapshotId = new LogId(0L, 0L);
    private final Map<Long, WaitMeta> waitMap = new HashMap<Long, WaitMeta>();
    private Disruptor<StableClosureEvent> disruptor;
    private RingBuffer<StableClosureEvent> diskQueue;
    private RaftOptions raftOptions;
    private volatile CountDownLatch shutDownLatch;
    private NodeMetrics nodeMetrics;
    private final CopyOnWriteArrayList<LogManager.LastLogIndexListener> lastLogIndexListeners = new CopyOnWriteArrayList();

    @Override
    public void addLastLogIndexListener(LogManager.LastLogIndexListener listener) {
        this.lastLogIndexListeners.add(listener);
    }

    @Override
    public void removeLastLogIndexListener(LogManager.LastLogIndexListener listener) {
        this.lastLogIndexListeners.remove(listener);
    }

    @Override
    public boolean init(LogManagerOptions opts) {
        this.writeLock.lock();
        try {
            if (opts.getLogStorage() == null) {
                LOG.error("Fail to init log manager, log storage is null");
                boolean bl = false;
                return bl;
            }
            this.raftOptions = opts.getRaftOptions();
            this.nodeMetrics = opts.getNodeMetrics();
            this.logStorage = opts.getLogStorage();
            this.configManager = opts.getConfigurationManager();
            if (!this.logStorage.init(this.configManager)) {
                LOG.error("Fail to init logStorage");
                boolean bl = false;
                return bl;
            }
            this.firstLogIndex = this.logStorage.getFirstLogIndex();
            this.lastLogIndex = this.logStorage.getLastLogIndex();
            this.diskId = new LogId(this.lastLogIndex, this.logStorage.getTerm(this.lastLogIndex));
            this.fsmCaller = opts.getFsmCaller();
            this.disruptor = new Disruptor((EventFactory)new StableClosureEventFactory(), opts.getDisruptorBufferSize(), (ThreadFactory)new NamedThreadFactory("Jraft-LogManager-Disruptor-", true));
            this.disruptor.handleEventsWith(new EventHandler[]{new StableClosureEventHandler()});
            this.disruptor.setDefaultExceptionHandler(new LogExceptionHandler<Object>(this.getClass().getSimpleName(), (event, ex) -> this.reportError(-1, "LogManager handle event error", new Object[0])));
            this.diskQueue = this.disruptor.getRingBuffer();
            this.disruptor.start();
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    private void stopDiskThread() {
        this.shutDownLatch = new CountDownLatch(1);
        this.diskQueue.publishEvent((event, sequence) -> {
            event.reset();
            event.type = EventType.SHUTDOWN;
        });
    }

    @Override
    public void join() throws InterruptedException {
        if (this.shutDownLatch == null) {
            return;
        }
        this.shutDownLatch.await();
        this.disruptor.shutdown();
    }

    @Override
    public void shutdown() {
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            doUnlock = false;
            this.wakeupAllWaiter(this.writeLock);
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
        this.stopDiskThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMemoryLogs(LogId id) {
        this.writeLock.lock();
        try {
            Iterator it = this.logsInMemory.iterator();
            while (it.hasNext()) {
                LogEntry entry = (LogEntry)it.next();
                if (entry.getId().compareTo(id) > 0) {
                    break;
                }
                it.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendEntries(List<LogEntry> entries, LogManager.StableClosure done) {
        Requires.requireNonNull(done, "done");
        if (this.hasError) {
            entries.clear();
            Utils.runClosureInThread(done, new Status(RaftError.EIO, "Corrupted LogStorage", new Object[0]));
            return;
        }
        boolean doUnlock = true;
        this.writeLock.lock();
        try {
            if (!entries.isEmpty() && !this.checkAndResolveConflict(entries, done)) {
                entries.clear();
                Utils.runClosureInThread(done, new Status(RaftError.EINTERNAL, "Fail to checkAndResolveConflict.", new Object[0]));
                return;
            }
            for (int i = 0; i < entries.size(); ++i) {
                LogEntry entry = entries.get(i);
                if (entry.getType() != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) continue;
                Configuration oldConf = new Configuration();
                if (entry.getOldPeers() != null) {
                    oldConf = new Configuration(entry.getOldPeers());
                }
                ConfigurationEntry conf = new ConfigurationEntry(entry.getId(), new Configuration(entry.getPeers()), oldConf);
                this.configManager.add(conf);
            }
            if (!entries.isEmpty()) {
                done.setFirstLogIndex(entries.get(0).getId().getIndex());
                this.logsInMemory.addAll(entries);
            }
            done.setEntries(entries);
            this.offerEvent(done, EventType.OTHER);
            doUnlock = false;
            if (!this.wakeupAllWaiter(this.writeLock)) {
                this.notifyLastLogIndexListeners();
            }
        }
        finally {
            if (doUnlock) {
                this.writeLock.unlock();
            }
        }
    }

    private void offerEvent(LogManager.StableClosure done, EventType type) {
        if (this.stopped) {
            Utils.runClosureInThread(done, new Status(RaftError.ESTOP, "Log manager is stopped.", new Object[0]));
            return;
        }
        this.diskQueue.publishEvent((event, sequence) -> {
            event.reset();
            event.type = type;
            event.done = done;
        });
    }

    private void notifyLastLogIndexListeners() {
        for (int i = 0; i < this.lastLogIndexListeners.size(); ++i) {
            LogManager.LastLogIndexListener listener = this.lastLogIndexListeners.get(i);
            if (listener == null) continue;
            try {
                listener.onLastLogIndexChanged(this.lastLogIndex);
                continue;
            }
            catch (Exception e) {
                LOG.error("Fail to notify LastLogIndexListener, listener={}, index={}", (Object)listener, (Object)this.lastLogIndex);
            }
        }
    }

    private boolean wakeupAllWaiter(Lock lock) {
        if (this.waitMap.isEmpty()) {
            lock.unlock();
            return false;
        }
        ArrayList<WaitMeta> wms = new ArrayList<WaitMeta>(this.waitMap.values());
        int errCode = this.stopped ? RaftError.ESTOP.getNumber() : RaftError.SUCCESS.getNumber();
        this.waitMap.clear();
        lock.unlock();
        int waiterCount = wms.size();
        for (int i = 0; i < waiterCount; ++i) {
            WaitMeta wm = (WaitMeta)wms.get(i);
            wm.errorCode = errCode;
            Utils.runInThread(() -> this.runOnNewLog(wm));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogId appendToStorage(List<LogEntry> toAppend) {
        LogId lastId = null;
        if (!this.hasError) {
            long startMs = Utils.monotonicMs();
            int entriesCount = toAppend.size();
            this.nodeMetrics.recordSize("append-logs-count", entriesCount);
            try {
                int writtenSize = 0;
                for (int i = 0; i < entriesCount; ++i) {
                    LogEntry entry = toAppend.get(i);
                    writtenSize += entry.getData() != null ? entry.getData().remaining() : 0;
                }
                this.nodeMetrics.recordSize("append-logs-bytes", writtenSize);
                int nAppent = this.logStorage.appendEntries(toAppend);
                if (nAppent != entriesCount) {
                    LOG.error("**Critical error**, fail to appendEntries, nAppent={}, toAppend={}", (Object)nAppent, (Object)toAppend.size());
                    this.reportError(RaftError.EIO.getNumber(), "Fail to append log entries", new Object[0]);
                }
                if (nAppent > 0) {
                    lastId = toAppend.get(nAppent - 1).getId();
                }
                toAppend.clear();
            }
            finally {
                this.nodeMetrics.recordLatency("append-logs", Utils.monotonicMs() - startMs);
            }
        }
        return lastId;
    }

    private void reportError(int code, String fmt, Object ... args) {
        this.hasError = true;
        RaftException error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_LOG);
        error.setStatus(new Status(code, fmt, args));
        this.fsmCaller.onError(error);
    }

    private void setDiskId(LogId id) {
        LogId clearId;
        this.writeLock.lock();
        try {
            if (id.compareTo(this.diskId) < 0) {
                return;
            }
            this.diskId = id;
            clearId = this.diskId.compareTo(this.appliedId) <= 0 ? this.diskId : this.appliedId;
        }
        finally {
            this.writeLock.unlock();
        }
        if (clearId != null) {
            this.clearMemoryLogs(clearId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSnapshot(RaftOutter.SnapshotMeta meta) {
        LOG.debug("set snapshot: {}", (Object)meta);
        this.writeLock.lock();
        try {
            if (meta.getLastIncludedIndex() <= this.lastSnapshotId.getIndex()) {
                return;
            }
            Configuration conf = new Configuration();
            for (int i = 0; i < meta.getPeersCount(); ++i) {
                PeerId peer = new PeerId();
                peer.parse(meta.getPeers(i));
                conf.addPeer(peer);
            }
            Configuration oldConf = new Configuration();
            for (int i = 0; i < meta.getOldPeersCount(); ++i) {
                PeerId peer = new PeerId();
                peer.parse(meta.getOldPeers(i));
                oldConf.addPeer(peer);
            }
            ConfigurationEntry entry = new ConfigurationEntry(new LogId(meta.getLastIncludedIndex(), meta.getLastIncludedTerm()), conf, oldConf);
            this.configManager.setSnapshot(entry);
            long term = this.unsafeGetTerm(meta.getLastIncludedIndex());
            long savedLastSnapshotIndex = this.lastSnapshotId.getIndex();
            this.lastSnapshotId.setIndex(meta.getLastIncludedIndex());
            this.lastSnapshotId.setTerm(meta.getLastIncludedTerm());
            if (this.lastSnapshotId.compareTo(this.appliedId) > 0) {
                this.appliedId = this.lastSnapshotId.copy();
            }
            if (term == 0L) {
                this.truncatePrefix(meta.getLastIncludedIndex() + 1L);
            } else if (term == meta.getLastIncludedTerm()) {
                if (savedLastSnapshotIndex > 0L) {
                    this.truncatePrefix(savedLastSnapshotIndex + 1L);
                }
            } else if (!this.reset(meta.getLastIncludedIndex() + 1L)) {
                LOG.warn("Reset log manager failed, nextLogIndex={}", (Object)(meta.getLastIncludedIndex() + 1L));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clearBufferedLogs() {
        this.writeLock.lock();
        try {
            if (this.lastSnapshotId.getIndex() != 0L) {
                this.truncatePrefix(this.lastSnapshotId.getIndex() + 1L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String descLogsInMemory() {
        StringBuilder sb = new StringBuilder();
        boolean wasFirst = true;
        for (LogEntry logEntry : this.logsInMemory) {
            if (!wasFirst) {
                sb.append(",");
            } else {
                wasFirst = false;
            }
            sb.append("<id:(").append(logEntry.getId().getTerm()).append(",").append(logEntry.getId().getIndex()).append("),type:").append((Object)logEntry.getType()).append(">");
        }
        return sb.toString();
    }

    protected LogEntry getEntryFromMemory(long index) {
        LogEntry entry = null;
        if (!this.logsInMemory.isEmpty()) {
            long firstIndex = this.logsInMemory.peekFirst().getId().getIndex();
            long lastIndex = this.logsInMemory.peekLast().getId().getIndex();
            Requires.requireTrue(lastIndex - firstIndex + 1L == (long)this.logsInMemory.size(), "lastIndex=%d,firstIndex=%d,logsInMemory=[%s]", lastIndex, firstIndex, this.descLogsInMemory());
            if (index >= firstIndex && index <= lastIndex) {
                entry = (LogEntry)this.logsInMemory.get((int)(index - firstIndex));
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        LogEntry entry;
        this.readLock.lock();
        try {
            if (index > this.lastLogIndex || index < this.firstLogIndex) {
                LogEntry logEntry = null;
                return logEntry;
            }
            entry = this.getEntryFromMemory(index);
            if (entry != null) {
                LogEntry logEntry = entry;
                return logEntry;
            }
        }
        finally {
            this.readLock.unlock();
        }
        entry = this.logStorage.getEntry(index);
        if (entry == null) {
            this.reportError(RaftError.EIO.getNumber(), "Corrupted entry at index=%d", index);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTerm(long index) {
        if (index == 0L) {
            return 0L;
        }
        this.readLock.lock();
        try {
            if (index > this.lastLogIndex) {
                long l = 0L;
                return l;
            }
            if (index == this.lastSnapshotId.getIndex()) {
                long l = this.lastSnapshotId.getTerm();
                return l;
            }
            LogEntry entry = this.getEntryFromMemory(index);
            if (entry != null) {
                long l = entry.getId().getTerm();
                return l;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.logStorage.getTerm(index);
    }

    @Override
    public long getFirstLogIndex() {
        this.readLock.lock();
        try {
            long l = this.firstLogIndex;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getLastLogIndex() {
        return this.getLastLogIndex(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastLogIndex(boolean isFlush) {
        LastLogIdClosure c;
        this.readLock.lock();
        try {
            if (!isFlush) {
                long l = this.lastLogIndex;
                return l;
            }
            if (this.lastLogIndex == this.lastSnapshotId.getIndex()) {
                long l = this.lastLogIndex;
                return l;
            }
            c = new LastLogIdClosure();
            this.offerEvent(c, EventType.LAST_LOG_ID);
        }
        finally {
            this.readLock.unlock();
        }
        try {
            c.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        return c.lastLogId.getIndex();
    }

    private long unsafeGetTerm(long index) {
        if (index == 0L) {
            return 0L;
        }
        if (index > this.lastLogIndex) {
            return 0L;
        }
        LogId lss = this.lastSnapshotId;
        if (index == lss.getIndex()) {
            return lss.getTerm();
        }
        LogEntry entry = this.getEntryFromMemory(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return this.logStorage.getTerm(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogId getLastLogId(boolean isFlush) {
        LastLogIdClosure c;
        this.readLock.lock();
        try {
            if (!isFlush) {
                if (this.lastLogIndex >= this.firstLogIndex) {
                    LogId logId = new LogId(this.lastLogIndex, this.unsafeGetTerm(this.lastLogIndex));
                    return logId;
                }
                LogId logId = this.lastSnapshotId;
                return logId;
            }
            if (this.lastLogIndex == this.lastSnapshotId.getIndex()) {
                LogId logId = this.lastSnapshotId;
                return logId;
            }
            c = new LastLogIdClosure();
            this.offerEvent(c, EventType.LAST_LOG_ID);
        }
        finally {
            this.readLock.unlock();
        }
        try {
            c.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        return c.lastLogId;
    }

    private boolean truncatePrefix(long firstIndexKept) {
        LogEntry entry;
        while (!this.logsInMemory.isEmpty() && (entry = this.logsInMemory.peekFirst()).getId().getIndex() < firstIndexKept) {
            this.logsInMemory.pollFirst();
        }
        Requires.requireTrue(firstIndexKept >= this.firstLogIndex, "Try to truncate logs before %d, but the firstLogIndex is %d", firstIndexKept, this.firstLogIndex);
        this.firstLogIndex = firstIndexKept;
        if (firstIndexKept > this.lastLogIndex) {
            this.lastLogIndex = firstIndexKept - 1L;
        }
        LOG.debug("Truncate prefix, firstIndexKept is :{}", (Object)firstIndexKept);
        this.configManager.truncatePrefix(firstIndexKept);
        TruncatePrefixClosure c = new TruncatePrefixClosure(firstIndexKept);
        this.offerEvent(c, EventType.TRUNCATE_PREFIX);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reset(long nextLogIndex) {
        this.writeLock.lock();
        try {
            this.logsInMemory = new ArrayDequeue();
            this.firstLogIndex = nextLogIndex;
            this.lastLogIndex = nextLogIndex - 1L;
            this.configManager.truncatePrefix(this.firstLogIndex);
            this.configManager.truncateSuffix(this.lastLogIndex);
            ResetClosure c = new ResetClosure(nextLogIndex);
            this.offerEvent(c, EventType.RESET);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void unsafeTruncateSuffix(long lastIndexKept) {
        LogEntry entry;
        if (lastIndexKept < this.appliedId.getIndex()) {
            LOG.error("FATAL ERROR: Can't truncate logs before appliedId={}, lastIndexKept={}", (Object)this.appliedId, (Object)lastIndexKept);
            return;
        }
        while (!this.logsInMemory.isEmpty() && (entry = this.logsInMemory.peekLast()).getId().getIndex() > lastIndexKept) {
            this.logsInMemory.pollLast();
        }
        this.lastLogIndex = lastIndexKept;
        long lastTermKept = this.unsafeGetTerm(lastIndexKept);
        Requires.requireTrue(this.lastLogIndex == 0L || lastTermKept != 0L);
        LOG.debug("Truncate suffix :{}", (Object)lastIndexKept);
        this.configManager.truncateSuffix(lastIndexKept);
        TruncateSuffixClosure c = new TruncateSuffixClosure(lastIndexKept, lastTermKept);
        this.offerEvent(c, EventType.TRUNCATE_SUFFIX);
    }

    private boolean checkAndResolveConflict(List<LogEntry> entries, LogManager.StableClosure done) {
        LogEntry firstLogEntry = ArrayDequeue.peekFirst(entries);
        if (firstLogEntry.getId().getIndex() == 0L) {
            for (int i = 0; i < entries.size(); ++i) {
                entries.get(i).getId().setIndex(++this.lastLogIndex);
            }
            return true;
        }
        if (firstLogEntry.getId().getIndex() > this.lastLogIndex + 1L) {
            Utils.runClosureInThread(done, new Status(RaftError.EINVAL, "There's gap between first_index=%d and last_log_index=%d", firstLogEntry.getId().getIndex(), this.lastLogIndex));
            return false;
        }
        long appliedIndex = this.appliedId.getIndex();
        LogEntry lastLogEntry = ArrayDequeue.peekLast(entries);
        if (lastLogEntry.getId().getIndex() <= appliedIndex) {
            LOG.warn("Received entries of which the lastLog={} is not greater than appliedIndex={}, return immediately with nothing changed.", (Object)lastLogEntry.getId().getIndex(), (Object)appliedIndex);
            return false;
        }
        if (firstLogEntry.getId().getIndex() == this.lastLogIndex + 1L) {
            this.lastLogIndex = lastLogEntry.getId().getIndex();
        } else {
            int conflictingIndex;
            for (conflictingIndex = 0; conflictingIndex < entries.size() && this.unsafeGetTerm(entries.get(conflictingIndex).getId().getIndex()) == entries.get(conflictingIndex).getId().getTerm(); ++conflictingIndex) {
            }
            if (conflictingIndex != entries.size()) {
                if (entries.get(conflictingIndex).getId().getIndex() <= this.lastLogIndex) {
                    this.unsafeTruncateSuffix(entries.get(conflictingIndex).getId().getIndex() - 1L);
                }
                this.lastLogIndex = lastLogEntry.getId().getIndex();
            }
            if (conflictingIndex > 0) {
                entries.subList(0, conflictingIndex).clear();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationEntry getConfiguration(long index) {
        this.readLock.lock();
        try {
            ConfigurationEntry configurationEntry = this.configManager.get(index);
            return configurationEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationEntry checkAndSetConfiguration(ConfigurationEntry current) {
        if (current == null) {
            return null;
        }
        this.readLock.lock();
        try {
            ConfigurationEntry lastConf = this.configManager.getLastConfiguration();
            if (lastConf != null && !lastConf.isEmpty() && !current.getId().equals(lastConf.getId())) {
                ConfigurationEntry configurationEntry = lastConf;
                return configurationEntry;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return current;
    }

    @Override
    public long wait(long expectedLastLogIndex, LogManager.onNewLogCallback cb, Object arg) {
        WaitMeta wm = new WaitMeta(cb, arg, 0);
        return this.notifyOnNewLog(expectedLastLogIndex, wm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long notifyOnNewLog(long expectedLastLogIndex, WaitMeta wm) {
        this.writeLock.lock();
        try {
            if (expectedLastLogIndex != this.lastLogIndex || this.stopped) {
                wm.errorCode = this.stopped ? RaftError.ESTOP.getNumber() : 0;
                Utils.runInThread(() -> this.runOnNewLog(wm));
                long l = 0L;
                return l;
            }
            if (this.nextWaitId == 0L) {
                ++this.nextWaitId;
            }
            long waitId = this.nextWaitId++;
            this.waitMap.put(waitId, wm);
            long l = waitId;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWaiter(long id) {
        this.writeLock.lock();
        try {
            boolean bl = this.waitMap.remove(id) != null;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void setAppliedId(LogId appliedId) {
        LogId clearId;
        this.writeLock.lock();
        try {
            if (appliedId.compareTo(this.appliedId) < 0) {
                return;
            }
            this.appliedId = appliedId.copy();
            clearId = this.diskId.compareTo(this.appliedId) <= 0 ? this.diskId : this.appliedId;
        }
        finally {
            this.writeLock.unlock();
        }
        if (clearId != null) {
            this.clearMemoryLogs(clearId);
        }
    }

    void runOnNewLog(WaitMeta wm) {
        wm.onNewLog.onNewLog(wm.arg, wm.errorCode);
    }

    @Override
    public Status checkConsistency() {
        this.readLock.lock();
        try {
            Requires.requireTrue(this.firstLogIndex > 0L);
            Requires.requireTrue(this.lastLogIndex >= 0L);
            if (this.lastSnapshotId.equals(new LogId(0L, 0L))) {
                if (this.firstLogIndex == 1L) {
                    Status status = Status.OK();
                    return status;
                }
                Status status = new Status(RaftError.EIO, "Missing logs in (0, %d)", this.firstLogIndex);
                return status;
            }
            if (this.lastSnapshotId.getIndex() >= this.firstLogIndex - 1L && this.lastSnapshotId.getIndex() <= this.lastLogIndex) {
                Status status = Status.OK();
                return status;
            }
            Status status = new Status(RaftError.EIO, "There's a gap between snapshot={%d, %d} and log=[%d, %d] ", this.lastSnapshotId.toString(), this.lastSnapshotId.getTerm(), this.firstLogIndex, this.lastLogIndex);
            return status;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class ResetClosure
    extends LogManager.StableClosure {
        long nextLogIndex;

        public ResetClosure(long nextLogIndex) {
            super(null);
            this.nextLogIndex = nextLogIndex;
        }

        @Override
        public void run(Status status) {
        }
    }

    private static class TruncateSuffixClosure
    extends LogManager.StableClosure {
        long lastIndexKept;
        long lastTermKept;

        public TruncateSuffixClosure(long lastIndexKept, long lastTermKept) {
            super(null);
            this.lastIndexKept = lastIndexKept;
            this.lastTermKept = lastTermKept;
        }

        @Override
        public void run(Status status) {
        }
    }

    private static class TruncatePrefixClosure
    extends LogManager.StableClosure {
        long firstIndexKept;

        public TruncatePrefixClosure(long firstIndexKept) {
            super(null);
            this.firstIndexKept = firstIndexKept;
        }

        @Override
        public void run(Status status) {
        }
    }

    private class StableClosureEventHandler
    implements EventHandler<StableClosureEvent> {
        LogId lastId;
        List<LogManager.StableClosure> storage;
        AppendBatcher ab;

        private StableClosureEventHandler() {
            this.lastId = LogManagerImpl.this.diskId;
            this.storage = new ArrayList<LogManager.StableClosure>(256);
            this.ab = new AppendBatcher(this.storage, 256, new ArrayList<LogEntry>(), LogManagerImpl.this.diskId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(StableClosureEvent event, long sequence, boolean endOfBatch) throws Exception {
            if (event.type == EventType.SHUTDOWN) {
                this.lastId = this.ab.flush();
                LogManagerImpl.this.setDiskId(this.lastId);
                LogManagerImpl.this.shutDownLatch.countDown();
                return;
            }
            LogManager.StableClosure done = event.done;
            if (done.getEntries() != null && !done.getEntries().isEmpty()) {
                this.ab.append(done);
            } else {
                this.lastId = this.ab.flush();
                boolean ret = true;
                switch (event.type) {
                    case LAST_LOG_ID: {
                        ((LastLogIdClosure)done).setLastLogId(this.lastId.copy());
                        break;
                    }
                    case TRUNCATE_PREFIX: {
                        long startMs = Utils.monotonicMs();
                        try {
                            TruncatePrefixClosure tpc = (TruncatePrefixClosure)done;
                            LOG.debug("Truncating storage to firstIndexKept={}", (Object)tpc.firstIndexKept);
                            ret = LogManagerImpl.this.logStorage.truncatePrefix(tpc.firstIndexKept);
                            break;
                        }
                        finally {
                            LogManagerImpl.this.nodeMetrics.recordLatency("truncate-log-prefix", Utils.monotonicMs() - startMs);
                        }
                    }
                    case TRUNCATE_SUFFIX: {
                        long startMs = Utils.monotonicMs();
                        try {
                            TruncateSuffixClosure tsc = (TruncateSuffixClosure)done;
                            LOG.warn("Truncating storage to lastIndexKept={}", (Object)tsc.lastIndexKept);
                            ret = LogManagerImpl.this.logStorage.truncateSuffix(tsc.lastIndexKept);
                            if (!ret) break;
                            this.lastId.setIndex(tsc.lastIndexKept);
                            this.lastId.setTerm(tsc.lastTermKept);
                            Requires.requireTrue(this.lastId.getIndex() == 0L || this.lastId.getTerm() != 0L);
                            break;
                        }
                        finally {
                            LogManagerImpl.this.nodeMetrics.recordLatency("truncate-log-suffix", Utils.monotonicMs() - startMs);
                        }
                    }
                    case RESET: {
                        ResetClosure rc = (ResetClosure)done;
                        LOG.info("Reseting storage to nextLogIndex={}", (Object)rc.nextLogIndex);
                        ret = LogManagerImpl.this.logStorage.reset(rc.nextLogIndex);
                        break;
                    }
                }
                if (!ret) {
                    LogManagerImpl.this.reportError(RaftError.EIO.getNumber(), "Failed operation in LogStorage", new Object[0]);
                } else {
                    done.run(Status.OK());
                }
            }
            if (endOfBatch) {
                this.lastId = this.ab.flush();
                LogManagerImpl.this.setDiskId(this.lastId);
            }
        }
    }

    private class AppendBatcher {
        List<LogManager.StableClosure> storage;
        int cap;
        int size;
        int bufferSize;
        List<LogEntry> toAppend;
        LogId lastId;

        public AppendBatcher(List<LogManager.StableClosure> storage, int cap, List<LogEntry> toAppend, LogId lastId) {
            this.storage = storage;
            this.cap = cap;
            this.toAppend = toAppend;
            this.lastId = lastId;
        }

        LogId flush() {
            if (this.size > 0) {
                this.lastId = LogManagerImpl.this.appendToStorage(this.toAppend);
                for (int i = 0; i < this.size; ++i) {
                    this.storage.get(i).getEntries().clear();
                    if (LogManagerImpl.this.hasError) {
                        this.storage.get(i).run(new Status(RaftError.EIO, "Corrupted LogStorage", new Object[0]));
                        continue;
                    }
                    this.storage.get(i).run(Status.OK());
                }
                this.toAppend.clear();
                this.storage.clear();
            }
            this.size = 0;
            this.bufferSize = 0;
            return this.lastId;
        }

        void append(LogManager.StableClosure done) {
            if (this.size == this.cap || this.bufferSize >= LogManagerImpl.this.raftOptions.getMaxAppendBufferSize()) {
                this.flush();
            }
            this.storage.add(done);
            ++this.size;
            this.toAppend.addAll(done.getEntries());
            for (LogEntry entry : done.getEntries()) {
                this.bufferSize += entry.getData() != null ? entry.getData().remaining() : 0;
            }
        }
    }

    private static class LastLogIdClosure
    extends LogManager.StableClosure {
        private LogId lastLogId;
        private final CountDownLatch latch = new CountDownLatch(1);

        public LastLogIdClosure() {
            super(null);
        }

        void setLastLogId(LogId logId) {
            Requires.requireTrue(logId.getIndex() == 0L || logId.getTerm() != 0L);
            this.lastLogId = logId;
        }

        @Override
        public void run(Status status) {
            this.latch.countDown();
        }

        void await() throws InterruptedException {
            this.latch.await();
        }
    }

    private static class WaitMeta {
        LogManager.onNewLogCallback onNewLog;
        int errorCode;
        Object arg;

        public WaitMeta(LogManager.onNewLogCallback onNewLog, Object arg, int errorCode) {
            this.onNewLog = onNewLog;
            this.arg = arg;
            this.errorCode = errorCode;
        }
    }

    private static class StableClosureEventFactory
    implements EventFactory<StableClosureEvent> {
        private StableClosureEventFactory() {
        }

        public StableClosureEvent newInstance() {
            return new StableClosureEvent();
        }
    }

    private static class StableClosureEvent {
        LogManager.StableClosure done;
        EventType type;

        private StableClosureEvent() {
        }

        void reset() {
            this.done = null;
            this.type = null;
        }
    }

    private static enum EventType {
        OTHER,
        RESET,
        TRUNCATE_PREFIX,
        TRUNCATE_SUFFIX,
        SHUTDOWN,
        LAST_LOG_ID;

    }
}

