/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepeatedTimer {
    public static final Logger LOG = LoggerFactory.getLogger(RepeatedTimer.class);
    private final Lock lock = new ReentrantLock();
    private final Timer timer;
    private TimerTask timerTask;
    private boolean stopped;
    private volatile boolean running;
    private boolean destroyed;
    private boolean invoking;
    private volatile int timeoutMs;
    private final String name;

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public RepeatedTimer(String name, int timeoutMs) {
        this.name = name;
        this.timeoutMs = timeoutMs;
        this.stopped = true;
        this.timer = new Timer(this.name);
    }

    protected abstract void onTrigger();

    protected int adjustTimeout(int timeoutMs) {
        return timeoutMs;
    }

    public void run() {
        this.lock.lock();
        try {
            this.invoking = true;
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.onTrigger();
        }
        catch (Throwable t) {
            LOG.error("run timer failed", t);
        }
        boolean invokeDestroyed = false;
        this.lock.lock();
        try {
            this.invoking = false;
            if (this.stopped) {
                this.running = false;
                invokeDestroyed = this.destroyed;
            } else {
                this.timerTask = null;
                this.schedule();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (invokeDestroyed) {
            this.onDestroy();
        }
    }

    public void runOnceNow() {
        this.lock.lock();
        try {
            if (this.timerTask != null && this.timerTask.cancel()) {
                this.timerTask = null;
                this.run();
                this.schedule();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void onDestroy() {
    }

    public void start() {
        this.lock.lock();
        try {
            if (this.destroyed) {
                return;
            }
            if (!this.stopped) {
                return;
            }
            this.stopped = false;
            if (this.running) {
                return;
            }
            this.running = true;
            this.schedule();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void schedule() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    RepeatedTimer.this.run();
                }
                catch (Throwable t) {
                    LOG.error("Run timer task failed taskName={}", (Object)RepeatedTimer.this.name, (Object)t);
                }
            }
        };
        this.timer.schedule(this.timerTask, this.adjustTimeout(this.timeoutMs));
    }

    public void reset(int timeoutMs) {
        this.lock.lock();
        this.timeoutMs = timeoutMs;
        try {
            if (this.stopped) {
                return;
            }
            if (this.running) {
                this.schedule();
            }
        }
        finally {
            this.lock.lock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.reset(this.timeoutMs);
        }
        finally {
            this.lock.lock();
        }
    }

    public void destroy() {
        boolean invokeDestroyed = false;
        this.lock.lock();
        try {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            if (!this.running) {
                invokeDestroyed = true;
            }
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            if (this.timerTask != null) {
                if (this.timerTask.cancel()) {
                    invokeDestroyed = true;
                    this.running = false;
                }
                this.timerTask = null;
            }
            this.timer.cancel();
        }
        finally {
            this.lock.unlock();
            if (invokeDestroyed) {
                this.onDestroy();
            }
        }
    }

    public String toString() {
        return "RepeatedTimer [lock=" + this.lock + ", timerTask=" + this.timerTask + ", stopped=" + this.stopped + ", running=" + this.running + ", destroyed=" + this.destroyed + ", invoking=" + this.invoking + ", timeoutMs=" + this.timeoutMs + "]";
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.running = false;
                this.timerTask = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

