/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.bootstrap;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.util.Utils;
import com.alipay.sofa.registry.jraft.command.ProcessRequest;
import com.alipay.sofa.registry.jraft.command.ProcessResponse;
import com.alipay.sofa.registry.jraft.processor.FollowerProcessListener;
import com.alipay.sofa.registry.jraft.processor.LeaderProcessListener;
import com.alipay.sofa.registry.jraft.processor.LeaderTaskClosure;
import com.alipay.sofa.registry.jraft.processor.Processor;
import com.alipay.sofa.registry.jraft.processor.SnapshotProcess;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class ServiceStateMachine
extends StateMachineAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceStateMachine.class);
    private LeaderProcessListener leaderProcessListener;
    private FollowerProcessListener followerProcessListener;
    private static volatile ServiceStateMachine instance;
    private AtomicLong leaderTerm = new AtomicLong(-1L);
    private AtomicLong followerTerm = new AtomicLong(-1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceStateMachine getInstance() {
        if (instance != null) return instance;
        Class<ServiceStateMachine> clazz = ServiceStateMachine.class;
        synchronized (ServiceStateMachine.class) {
            if (instance != null) return instance;
            instance = new ServiceStateMachine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isLeader() {
        return this.leaderTerm.get() > 0L;
    }

    public boolean isfollower() {
        return this.followerTerm.get() > 0L;
    }

    public void onApply(Iterator iter) {
        while (iter.hasNext()) {
            ProcessRequest request;
            Closure done = iter.done();
            ByteBuffer data = iter.getData();
            LeaderTaskClosure closure = null;
            if (done != null) {
                closure = (LeaderTaskClosure)done;
                request = closure.getRequest();
            } else {
                Hessian2Input input = new Hessian2Input((InputStream)new ByteArrayInputStream(data.array()));
                SerializerFactory serializerFactory = new SerializerFactory();
                input.setSerializerFactory(serializerFactory);
                try {
                    request = (ProcessRequest)input.readObject();
                    input.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred when Hessian serializer decode!", e);
                }
            }
            ProcessResponse response = Processor.getInstance().process(request);
            if (closure != null) {
                closure.setResponse(response);
                closure.run(Status.OK());
            }
            iter.next();
        }
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        Map<String, Object> workers = Processor.getInstance().getWorkers();
        HashMap snapshotProcessors = new HashMap();
        if (workers != null) {
            workers.forEach((serviceId, worker) -> {
                if (worker instanceof SnapshotProcess) {
                    SnapshotProcess snapshotProcessor = (SnapshotProcess)worker;
                    snapshotProcessors.put(serviceId, snapshotProcessor.copy());
                }
            });
        }
        Utils.runInThread(() -> {
            String errors = null;
            block0: for (Map.Entry entry : snapshotProcessors.entrySet()) {
                String serviceId = (String)entry.getKey();
                SnapshotProcess snapshotProcessor = (SnapshotProcess)entry.getValue();
                Set<String> fileNames = snapshotProcessor.getSnapshotFileNames();
                for (String fileName : fileNames) {
                    String savePath = writer.getPath() + File.separator + fileName;
                    LOG.info("Begin save snapshot path {}", (Object)savePath);
                    boolean ret = snapshotProcessor.save(savePath);
                    if (ret) {
                        if (writer.addFile(fileName)) continue;
                        errors = String.format("Fail to add file %s to writer", fileName);
                        break block0;
                    }
                    errors = String.format("Fail to save service:%s snapshot %s", serviceId, savePath);
                    break block0;
                }
            }
            if (errors != null) {
                done.run(new Status(RaftError.EIO, errors, new Object[0]));
            } else {
                done.run(Status.OK());
            }
        });
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (this.isLeader()) {
            LOG.warn("Leader is not supposed to load snapshot");
            return false;
        }
        ArrayList<String> failServices = new ArrayList<String>();
        Map<String, Object> workers = Processor.getInstance().getWorkers();
        if (workers != null) {
            block0: for (Map.Entry<String, Object> entry : workers.entrySet()) {
                String serviceId = entry.getKey();
                Object worker = entry.getValue();
                if (!(worker instanceof SnapshotProcess)) continue;
                SnapshotProcess snapshotProcess = (SnapshotProcess)worker;
                Set<String> fileNames = snapshotProcess.getSnapshotFileNames();
                for (String fileName : fileNames) {
                    if (reader.getFileMeta(fileName) == null) {
                        LOG.error("Fail to find data file {} in {}", (Object)fileName, (Object)reader.getPath());
                        failServices.add(serviceId);
                        break block0;
                    }
                    String savePath = reader.getPath() + File.separator + fileName;
                    LOG.info("Begin load snapshot path {}", (Object)savePath);
                    boolean ret = snapshotProcess.load(savePath);
                    if (ret) continue;
                    LOG.error("Fail to load service:{} snapshot {}", (Object)serviceId, (Object)savePath);
                    failServices.add(serviceId);
                    break block0;
                }
            }
        }
        if (!failServices.isEmpty()) {
            LOG.error("Fail to load services {} snapshot!", failServices);
            return false;
        }
        return true;
    }

    public void onLeaderStart(long term) {
        this.leaderTerm.set(term);
        if (this.leaderProcessListener != null) {
            Utils.runInThread(() -> this.leaderProcessListener.startProcess());
        }
        super.onLeaderStart(term);
    }

    public void onLeaderStop(Status status) {
        this.leaderTerm.set(-1L);
        if (this.leaderProcessListener != null) {
            Utils.runInThread(() -> this.leaderProcessListener.stopProcess());
        }
        super.onLeaderStop(status);
    }

    public void onStopFollowing(LeaderChangeContext ctx) {
        this.followerTerm.set(-1L);
        if (this.followerProcessListener != null) {
            Utils.runInThread(() -> this.followerProcessListener.stopProcess(ctx.getLeaderId()));
        }
        super.onStopFollowing(ctx);
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        this.followerTerm.set(1L);
        if (this.followerProcessListener != null) {
            Utils.runInThread(() -> this.followerProcessListener.startProcess(ctx.getLeaderId()));
        }
        super.onStartFollowing(ctx);
    }

    public void setLeaderProcessListener(LeaderProcessListener leaderProcessListener) {
        this.leaderProcessListener = leaderProcessListener;
    }

    public void setFollowerProcessListener(FollowerProcessListener followerProcessListener) {
        this.followerProcessListener = followerProcessListener;
    }
}

