/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.handler;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.jraft.command.NotifyLeaderChange;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;

public class NotifyLeaderChangeHandler
implements ChannelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyLeaderChangeHandler.class);
    private String groupId;
    private CliClientService clientService;

    public NotifyLeaderChangeHandler(String groupId, CliClientService clientService) {
        this.groupId = groupId;
        this.clientService = clientService;
    }

    public void connected(Channel channel) {
    }

    public void disconnected(Channel channel) {
    }

    public void received(Channel channel, Object message) {
    }

    public Object reply(Channel channel, Object message) {
        PeerId peerId;
        NotifyLeaderChange notifyLeaderChange = (NotifyLeaderChange)message;
        LOGGER.info("Receive NotifyLeaderChange request:{},remote address:{}, localAddress:", new Object[]{notifyLeaderChange, channel.getRemoteAddress(), channel.getLocalAddress()});
        if (this.clientService != null && (peerId = RaftClient.refreshLeader(this.clientService, this.groupId, 5000)) != null) {
            LOGGER.info("Reset leader for raft group {},leader()", (Object)this.groupId, (Object)peerId);
        }
        return null;
    }

    public void caught(Channel channel, Object message, Throwable exception) {
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    public Class interest() {
        return NotifyLeaderChange.class;
    }
}

