/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.handler;

import com.alipay.remoting.AsyncContext;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.registry.jraft.bootstrap.RaftServer;
import com.alipay.sofa.registry.jraft.command.ProcessRequest;
import com.alipay.sofa.registry.jraft.command.ProcessResponse;
import com.alipay.sofa.registry.jraft.processor.LeaderTaskClosure;
import com.alipay.sofa.registry.jraft.processor.Processor;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.RemotingException;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class RaftServerHandler
implements ChannelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftServerHandler.class);
    protected RaftServer raftServer;

    public RaftServerHandler(RaftServer raftServer) {
        this.raftServer = raftServer;
    }

    public void connected(Channel channel) {
    }

    public void disconnected(Channel channel) {
    }

    public void caught(Channel channel, Object message, Throwable exception) {
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    public Class interest() {
        return ProcessRequest.class;
    }

    public void received(Channel channel, Object message) throws RemotingException {
        if (!(channel instanceof BoltChannel)) {
            LOGGER.error("Raft receive message channel error type!");
            throw new RemotingException("Raft receive message channel error type!");
        }
        if (!(message instanceof ProcessRequest)) {
            LOGGER.error("Raft receive message error type!");
            throw new RemotingException("Raft receive message error type!");
        }
        BoltChannel boltChannel = (BoltChannel)channel;
        AsyncContext asyncContext = boltChannel.getAsyncContext();
        if (!this.raftServer.getFsm().isLeader()) {
            asyncContext.sendResponse((Object)ProcessResponse.redirect(this.raftServer.redirect()).build());
            return;
        }
        ProcessRequest processRequest = (ProcessRequest)message;
        long start = System.currentTimeMillis();
        Method method = Processor.getInstance().getWorkMethod(processRequest);
        if (Processor.getInstance().isLeaderReadMethod(method)) {
            ProcessResponse obj = Processor.getInstance().process(method, processRequest);
            long cost = System.currentTimeMillis() - start;
            LOGGER.info("Raft server process request self cost:{},request={}", (Object)cost, (Object)processRequest);
            asyncContext.sendResponse((Object)obj);
        } else {
            LeaderTaskClosure closure = new LeaderTaskClosure();
            closure.setRequest(processRequest);
            closure.setDone(status -> {
                long cost = System.currentTimeMillis() - start;
                LOGGER.info("Raft server process request by task cost:{},request={},status={}", new Object[]{cost, processRequest, status});
                if (status.isOk()) {
                    asyncContext.sendResponse(closure.getResponse());
                } else {
                    asyncContext.sendResponse((Object)ProcessResponse.fail(status.getErrorMsg()).build());
                }
            });
            Task task = this.createTask(closure, processRequest);
            this.raftServer.getNode().apply(task);
        }
    }

    protected Task createTask(LeaderTaskClosure closure, ProcessRequest request) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        Hessian2Output hessianOutput = new Hessian2Output((OutputStream)byteStream);
        SerializerFactory serializerFactory = new SerializerFactory();
        hessianOutput.setSerializerFactory(serializerFactory);
        try {
            hessianOutput.writeObject((Object)request);
            hessianOutput.close();
        }
        catch (IOException e) {
            LOGGER.error("Raft receive message serialize error!", (Throwable)e);
        }
        byte[] cmdBytes = byteStream.toByteArray();
        ByteBuffer data = ByteBuffer.allocate(cmdBytes.length);
        data.put(cmdBytes);
        data.flip();
        return new Task(data, (Closure)closure);
    }

    public Object reply(Channel channel, Object message) {
        return null;
    }

    public ChannelHandler.InvokeType getInvokeType() {
        return ChannelHandler.InvokeType.ASYNC;
    }
}

