/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.jraft.processor;

import com.alipay.sofa.registry.jraft.bootstrap.ServiceStateMachine;
import com.alipay.sofa.registry.jraft.command.ProcessRequest;
import com.alipay.sofa.registry.jraft.command.ProcessResponse;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.store.api.annotation.ReadOnLeader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Processor {
    private static final Logger LOG = LoggerFactory.getLogger(Processor.class);
    private Map<String, Map<String, Method>> workerMethods = new HashMap<String, Map<String, Method>>();
    private Map<String, Object> workers = new HashMap<String, Object>();
    private static volatile Processor instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Processor getInstance() {
        if (instance != null) return instance;
        Class<Processor> clazz = Processor.class;
        synchronized (Processor.class) {
            if (instance != null) return instance;
            instance = new Processor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addWorker(String serviceId, Class interfaceClazz, Object target) {
        if (this.workers.get(serviceId) != null) {
            LOG.warn("Service {} has bean existed!", (Object)serviceId);
            return;
        }
        HashMap<String, Method> publicMethods = new HashMap<String, Method>();
        for (Method m : interfaceClazz.getMethods()) {
            StringBuilder mSigs = new StringBuilder();
            mSigs.append(m.getName());
            for (Class<?> paramType : m.getParameterTypes()) {
                mSigs.append(paramType.getName());
            }
            publicMethods.put(mSigs.toString(), m);
        }
        this.workerMethods.put(serviceId, publicMethods);
        this.workers.put(serviceId, target);
    }

    public ProcessResponse process(ProcessRequest request) {
        String methodName = request.getMethodName();
        String serviceId = request.getServiceName();
        Object target = this.workers.get(serviceId);
        if (target == null) {
            LOG.warn("Can not find service {} from process!", (Object)serviceId);
            return ProcessResponse.fail(String.format("Can not find service %s from process!", serviceId)).build();
        }
        try {
            StringBuilder methodKeyBuffer = new StringBuilder();
            methodKeyBuffer.append(methodName);
            String[] sig = request.getMethodArgSigs();
            for (int i = 0; i < sig.length; ++i) {
                methodKeyBuffer.append(sig[i]);
            }
            Method appServiceMethod = this.workerMethods.get(serviceId).get(methodKeyBuffer.toString());
            if (appServiceMethod == null) {
                LOG.error("Can not find method {} from processor by serviceId {}", (Object)methodName, (Object)serviceId);
                throw new NoSuchMethodException("Can not find method from processor\uff01");
            }
            Object[] methodArg = request.getMethodArgs();
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(appServiceMethod);
            Object ret = methodHandle.bindTo(target).invokeWithArguments(methodArg);
            if (ret != null) {
                return ProcessResponse.ok(ret).build();
            }
            return ProcessResponse.ok().build();
        }
        catch (Throwable e) {
            LOG.error("Process service request {} error!", (Object)request, (Object)e);
            return ProcessResponse.fail(String.format("Process service %s method %s error!", serviceId, methodName)).build();
        }
    }

    public ProcessResponse process(Method method, ProcessRequest request) {
        String methodName = request.getMethodName();
        String serviceId = request.getServiceName();
        Object target = this.workers.get(serviceId);
        if (target == null) {
            LOG.warn("Can not find service {} from process!", (Object)serviceId);
            return ProcessResponse.fail(String.format("Can not find service %s from process!", serviceId)).build();
        }
        try {
            Object[] methodArg = request.getMethodArgs();
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
            Object ret = methodHandle.bindTo(target).invokeWithArguments(methodArg);
            if (ret != null) {
                return ProcessResponse.ok(ret).build();
            }
            return ProcessResponse.ok().build();
        }
        catch (Throwable e) {
            LOG.error("Process service request {} error!", (Object)request, (Object)e);
            return ProcessResponse.fail(String.format("Process service %s method %s error!", serviceId, methodName)).build();
        }
    }

    public Method getWorkMethod(ProcessRequest request) {
        String methodName = request.getMethodName();
        String serviceId = request.getServiceName();
        try {
            StringBuilder methodKeyBuffer = new StringBuilder();
            methodKeyBuffer.append(methodName);
            String[] sig = request.getMethodArgSigs();
            for (int i = 0; i < sig.length; ++i) {
                methodKeyBuffer.append(sig[i]);
            }
            Method appServiceMethod = this.workerMethods.get(serviceId).get(methodKeyBuffer.toString());
            if (appServiceMethod == null) {
                LOG.error("Can not find method {} from processor by serviceId {}", (Object)methodName, (Object)serviceId);
                throw new NoSuchMethodException("Can not find method from processor\uff01");
            }
            return appServiceMethod;
        }
        catch (Exception e) {
            LOG.error("Process request {} get WorkMethod error!", (Object)request, (Object)e);
            throw new RuntimeException(String.format("Process request %s get WorkMethod error!", request));
        }
    }

    public Map<String, Object> getWorkers() {
        return this.workers;
    }

    public boolean isLeaderReadMethod(Method method) {
        if (ServiceStateMachine.getInstance().isLeader()) {
            return method != null && method.isAnnotationPresent(ReadOnLeader.class);
        }
        return false;
    }
}

