/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ocr_api20210707.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.io.InputStream;

public class RecognizeInvoiceRequest
extends Request {
    @Query
    @NameInMap(value="PageNo")
    private Integer pageNo;
    @Query
    @NameInMap(value="Url")
    @Validation(maxLength=2048)
    private String url;
    @Body
    @NameInMap(value="body")
    private InputStream body;

    private RecognizeInvoiceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.pageNo = builder.pageNo;
        this.url = builder.url;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RecognizeInvoiceRequest create() {
        return RecognizeInvoiceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public String getUrl() {
        return this.url;
    }

    public InputStream getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<RecognizeInvoiceRequest, Builder> {
        private Integer pageNo;
        private String url;
        private InputStream body;

        private Builder() {
        }

        private Builder(RecognizeInvoiceRequest request) {
            super((Request)request);
            this.pageNo = request.pageNo;
            this.url = request.url;
            this.body = request.body;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder url(String url) {
            this.putQueryParameter("Url", url);
            this.url = url;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public RecognizeInvoiceRequest build() {
            return new RecognizeInvoiceRequest(this);
        }
    }
}

