/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.auth;

import com.aliyun.auth.signature.exception.SignatureException;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.EncodeUtil;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;

public class RpcSignatureComposer {
    private static final String SEPARATOR = "&";

    public static String composeStringToSign(HttpMethod method, Map<String, String> params, Map<String, String> headers, String pathname) {
        StringBuilder stringToSign = new StringBuilder();
        try {
            stringToSign.append(method);
            stringToSign.append(SEPARATOR);
            stringToSign.append(EncodeUtil.percentEncode((String)pathname));
            stringToSign.append(SEPARATOR);
            stringToSign.append(EncodeUtil.percentEncode((String)RpcSignatureComposer.buildCanonicalizedResource(params)));
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
        return stringToSign.toString();
    }

    private static String buildCanonicalizedResource(Map<String, String> params) {
        Object[] sortedKeys = params.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder queryString = new StringBuilder();
        try {
            for (Object key : sortedKeys) {
                if (null == params.get(key)) continue;
                queryString.append(SEPARATOR).append(EncodeUtil.percentEncode((String)key)).append("=").append(EncodeUtil.percentEncode((String)params.get(key)));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
        return queryString.length() > 0 ? queryString.substring(1) : "";
    }
}

