/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry.backoff;

import com.aliyun.core.utils.Validate;
import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.policy.retry.backoff.BackoffStrategy;
import java.time.Duration;
import java.util.Random;

public final class FullJitterBackoffStrategy
implements BackoffStrategy {
    private static final Duration BASE_DELAY_CEILING = Duration.ofDays(3L);
    private static final Duration MAX_BACKOFF_CEILING = Duration.ofDays(3L);
    private final Duration baseDelay;
    private final Duration maxBackoffTime;
    private final Random random;

    private FullJitterBackoffStrategy(BuilderImpl builder) {
        this(builder.baseDelay, builder.maxBackoffTime, new Random());
    }

    FullJitterBackoffStrategy(Duration baseDelay, Duration maxBackoffTime, Random random) {
        this.baseDelay = Duration.ofNanos(Math.min(Validate.isNotNegative((Duration)baseDelay, (String)"baseDelay").toNanos(), BASE_DELAY_CEILING.toNanos()));
        this.maxBackoffTime = Duration.ofNanos(Math.min(Validate.isNotNegative((Duration)maxBackoffTime, (String)"maxBackoffTime").toNanos(), MAX_BACKOFF_CEILING.toNanos()));
        this.random = random;
    }

    @Override
    public Duration computeDelayBeforeNextRetry(RetryPolicyContext context) {
        int ceil = this.calculateExponentialDelay(context.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
        return Duration.ofMillis(this.random.nextInt(ceil));
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    implements Builder {
        private Duration baseDelay;
        private Duration maxBackoffTime;

        private BuilderImpl() {
        }

        @Override
        public Builder baseDelay(Duration baseDelay) {
            this.baseDelay = baseDelay;
            return this;
        }

        public void setBaseDelay(Duration baseDelay) {
            this.baseDelay(baseDelay);
        }

        @Override
        public Duration baseDelay() {
            return this.baseDelay;
        }

        @Override
        public Builder maxBackoffTime(Duration maxBackoffTime) {
            this.maxBackoffTime = maxBackoffTime;
            return this;
        }

        public void setMaxBackoffTime(Duration maxBackoffTime) {
            this.maxBackoffTime(maxBackoffTime);
        }

        @Override
        public Duration maxBackoffTime() {
            return this.maxBackoffTime;
        }

        @Override
        public FullJitterBackoffStrategy build() {
            return new FullJitterBackoffStrategy(this);
        }
    }

    public static interface Builder {
        public Builder baseDelay(Duration var1);

        public Duration baseDelay();

        public Builder maxBackoffTime(Duration var1);

        public Duration maxBackoffTime();

        public FullJitterBackoffStrategy build();
    }
}

