/*
 * Decompiled with CFR 0.152.
 */
package com.banboocloud.Codec;

import com.banboocloud.Codec.BamBoocloudSignature;
import com.banboocloud.Codec.BamboocloudCipher;
import com.banboocloud.Codec.ClassUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class BamboocloudFacade {
    private static Map<String, BamboocloudCipher> ciphers = new HashMap<String, BamboocloudCipher>();
    private static Map<String, BamBoocloudSignature> signatures = new HashMap<String, BamBoocloudSignature>();

    static {
        try {
            ArrayList<Class> cipherslist = ClassUtil.getAllClassByInterface(BamboocloudCipher.class);
            for (Class classz : cipherslist) {
                BamboocloudCipher cipher = (BamboocloudCipher)classz.newInstance();
                ciphers.put(cipher.AlgorithmName(), cipher);
            }
            ArrayList<Class> signatureslist = ClassUtil.getAllClassByInterface(BamBoocloudSignature.class);
            for (Class classz : signatureslist) {
                BamBoocloudSignature Signature = (BamBoocloudSignature)classz.newInstance();
                signatures.put(Signature.AlgorithmName(), Signature);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static String encrypt(String plaintext, String key, String type) {
        BamboocloudCipher cipher = ciphers.get(type);
        if (cipher != null) {
            return cipher.encrypt(plaintext, key);
        }
        return "";
    }

    public static String decrypt(String ciphertext, String key, String type) {
        BamboocloudCipher cipher = ciphers.get(type);
        if (cipher != null) {
            return cipher.decrypt(ciphertext, key);
        }
        return "";
    }

    public static String signature(String plaintext, String type) {
        BamBoocloudSignature signature = signatures.get(type);
        if (signature != null) {
            return signature.signature(plaintext);
        }
        return "";
    }

    public static Boolean verify(String sign, String plaintext, String type) {
        BamBoocloudSignature signature = signatures.get(type);
        if (signature != null) {
            return signature.verify(sign, plaintext);
        }
        return false;
    }

    public static void main(String[] args) {
        String sss = BamboocloudFacade.encrypt("\u4eca\u5929\u771f\u9ad8\u5174\uff01\u53bb\u5403\u9ebb\u8fa3\u70eb\u5427\u3002", "123456", "AES");
        System.out.println("\u6211\u8bf4 --\uff1a" + sss);
        String ss = BamboocloudFacade.decrypt(sss, "123456", "AES");
        System.out.println("\u542c\u89c1\u4e86\u6ca1\u6709 --\uff1a" + ss);
        System.out.println(BamboocloudFacade.decrypt("sdNcgztUp4C6g+U1oKFGihXxvxmILB/HjZYbejH7CPI5Ta1DXXA1F2R5yOy34HI9poSvS+TzYD+7dOJ7ob5MZcf4PisBueG10xt/56D8ioCJYDNhjTbBWmlQx/U0lk8PvG36XzBBQcoHhN66IHY3Mlq/l0HTzjTh7Bbi1VbJVJge16OzDtnXtT7MAvSPi5Tdq8/C1UetSJDbnwG3lF/NHjBuufWQiUT9Du032q8MckWxkOw+Wf6cGwvNQpXUPSHKBIZs8ld2DlETa5rk0bybaoy8TLQ0NmcCDlwbtIK9rsCpBjRYlKTMv9FoAl5Od9d+E6m7DqRePt6i/bQvpsvEHIylTK3O3PbTs2W6p0HoeYPkarkHI6MQMRX8zQWd02en0gOhhENoXDpfB7hOXjWABIlFWFtyC3VHIkQPfCCe93HdB/jZx9MacniaxpZU3X7A", "123456", "AES"));
        String s = BamboocloudFacade.signature("bimRemotePwd=password&bimRemoteUser=BIMadmin&bimRequestId=9e928d12ec8a4c1bb75283b8df71308d", "MD5");
        System.out.println("\u7b7e\u540d --\uff1a" + s);
    }
}

