/*
 * Decompiled with CFR 0.152.
 */
package com.banboocloud.Codec;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static ArrayList<Class> getAllClassByInterface(Class clazz) {
        ArrayList<Class> list = new ArrayList<Class>();
        if (clazz.isInterface()) {
            try {
                ArrayList<Class> allClass = ClassUtil.getAllClass(clazz.getPackage().getName());
                int i = 0;
                while (i < allClass.size()) {
                    if (clazz.isAssignableFrom(allClass.get(i)) && !clazz.equals(allClass.get(i))) {
                        list.add(allClass.get(i));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("\u51fa\u73b0\u5f02\u5e38");
            }
        } else {
            try {
                ArrayList<Class> allClass = ClassUtil.getAllClass(clazz.getPackage().getName());
                int i = 0;
                while (i < allClass.size()) {
                    if (clazz.isAssignableFrom(allClass.get(i)) && !clazz.equals(allClass.get(i))) {
                        list.add(allClass.get(i));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("\u51fa\u73b0\u5f02\u5e38");
            }
        }
        return list;
    }

    private static ArrayList<Class> getAllClass(String packagename) {
        ArrayList<Class> list = new ArrayList<Class>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packagename.replace('.', '/');
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            Enumeration<URL> enumeration = classLoader.getResources(path);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                if (url.openConnection() instanceof JarURLConnection) {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    JarFile jarfile = conn.getJarFile();
                    Enumeration<JarEntry> jarfiles = jarfile.entries();
                    while (jarfiles.hasMoreElements()) {
                        JarEntry jarentry = jarfiles.nextElement();
                        if (!jarentry.getName().endsWith(".class") || !jarentry.getName().contains(path)) continue;
                        String classname = jarentry.getName().substring(0, jarentry.getName().length() - 6).replace('/', '.');
                        try {
                            list.add(Class.forName(classname));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                fileList.add(new File(url.getFile()));
            }
            int i = 0;
            while (i < fileList.size()) {
                list.addAll(ClassUtil.findClass((File)fileList.get(i), packagename));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static ArrayList<Class> findClass(File file, String packagename) {
        File[] files;
        ArrayList<Class> list = new ArrayList<Class>();
        if (!file.exists()) {
            return list;
        }
        File[] fileArray = files = file.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                if (!file2.getName().contains(".")) {
                    ArrayList<Class> arrayList = ClassUtil.findClass(file2, String.valueOf(packagename) + "." + file2.getName());
                    list.addAll(arrayList);
                }
            } else if (file2.getName().endsWith(".class")) {
                try {
                    list.add(Class.forName(String.valueOf(packagename) + '.' + file2.getName().substring(0, file2.getName().length() - 6)));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return list;
    }
}

