/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.generator.ITemplate;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.BaseBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.function.ConverterFileName;
import com.baomidou.mybatisplus.generator.util.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.LoggingCache;
import org.jetbrains.annotations.NotNull;

public class Mapper
implements ITemplate {
    private String superClass = "com.baomidou.mybatisplus.core.mapper.BaseMapper";
    private boolean mapperAnnotation;
    private boolean baseResultMap;
    private boolean baseColumnList;
    private ConverterFileName converterMapperFileName = entityName -> entityName + "Mapper";
    private ConverterFileName converterXmlFileName = entityName -> entityName + "Mapper";
    private boolean fileOverride;
    private Class<? extends Cache> cache;

    private Mapper() {
    }

    @NotNull
    public String getSuperClass() {
        return this.superClass;
    }

    public boolean isMapperAnnotation() {
        return this.mapperAnnotation;
    }

    public boolean isBaseResultMap() {
        return this.baseResultMap;
    }

    public boolean isBaseColumnList() {
        return this.baseColumnList;
    }

    public ConverterFileName getConverterMapperFileName() {
        return this.converterMapperFileName;
    }

    public ConverterFileName getConverterXmlFileName() {
        return this.converterXmlFileName;
    }

    public Class<? extends Cache> getCache() {
        return this.cache == null ? LoggingCache.class : this.cache;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean enableCache = this.cache != null;
        data.put("enableCache", enableCache);
        data.put("mapperAnnotation", this.mapperAnnotation);
        data.put("baseResultMap", this.baseResultMap);
        data.put("baseColumnList", this.baseColumnList);
        data.put("superMapperClassPackage", this.superClass);
        if (enableCache) {
            Class<? extends Cache> cacheClass = this.getCache();
            data.put("cache", cacheClass);
            data.put("cacheClassName", cacheClass.getName());
        }
        data.put("superMapperClass", ClassUtils.getSimpleName(this.superClass));
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final Mapper mapper = new Mapper();

        public Builder(StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder superClass(@NotNull String superClass) {
            this.mapper.superClass = superClass;
            return this;
        }

        public Builder superClass(@NotNull Class<?> superClass) {
            return this.superClass(superClass.getName());
        }

        public Builder enableMapperAnnotation() {
            this.mapper.mapperAnnotation = true;
            return this;
        }

        public Builder enableBaseResultMap() {
            this.mapper.baseResultMap = true;
            return this;
        }

        public Builder enableBaseColumnList() {
            this.mapper.baseColumnList = true;
            return this;
        }

        public Builder cache(@NotNull Class<? extends Cache> cache) {
            this.mapper.cache = cache;
            return this;
        }

        public Builder convertMapperFileName(@NotNull ConverterFileName converter) {
            this.mapper.converterMapperFileName = converter;
            return this;
        }

        public Builder convertXmlFileName(@NotNull ConverterFileName converter) {
            this.mapper.converterXmlFileName = converter;
            return this;
        }

        public Builder formatMapperFileName(@NotNull String format) {
            return this.convertMapperFileName(entityName -> String.format(format, entityName));
        }

        public Builder formatXmlFileName(@NotNull String format) {
            return this.convertXmlFileName(entityName -> String.format(format, entityName));
        }

        public Builder fileOverride() {
            this.mapper.fileOverride = true;
            return this;
        }

        @NotNull
        public Mapper get() {
            return this.mapper;
        }
    }
}

