#!/usr/bin/perl
require 'getopts.pl';
require 'config.pl';
require 'client.pl';
require 'server.pl';
require 'self.pl';
require 'compat.pl';
require 'util.pl';
require 'remote.pl';
require 'test-ca.pl';

$GONATIVEVER="1b1";

&Getopts("IfnN:RD:vc:t:T:");

# Test a release	
if($opt_D){
  $DEBUG_FLAGS="-d $opt_D";
}
$VERBOSE=1 if $opt_v;
if($opt_R){
  $PWD=`pwd`;
  chop($PWD);
  $CLASSPATH="${PWD}/../../../../../build/puretls.jar:${PWD}/../../../../../build/puretlsdemo.jar:/users/ekr/src/java/cryptix32.jar:/users/ekr/src/java/cryptix-asn1.jar:/usr/local/jdk1.4.2/lib";
  $GONATIVEDIR="$PWD/../../gnp-${GONATIVEVER}/gnp-$GONATIVEVER";
  $GONATIVEDIR=$opt_N if $opt_N;
$ENV{'CLASSPATH'}=$CLASSPATH;
}

%TESTS=(
	'ca',1,
	'openssl',1,
	'self',1,
	'other',1
);

	
if($opt_T){
  @remove=split(/:/,$opt_T);
  foreach $x (@remove){
    $TESTS{$x}=0;
  }
}

if($opt_t){
  %TESTS=();

  @add=split(/:/,$opt_t);
  foreach $x (@add){
    $TESTS{$x}=1;
  }

}

@CIPHERSUITES=(
   "",
  "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA",
  "TLS_DHE_DSS_WITH_DES_CBC_SHA",
  "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA",
  "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
  "TLS_RSA_WITH_DES_CBC_SHA",
  "TLS_RSA_WITH_RC4_128_MD5",
  "TLS_RSA_WITH_RC4_128_SHA",
  "TLS_RSA_EXPORT_WITH_RC4_40_MD5",
  "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5",
  "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA",
  "TLS_RSA_WITH_NULL_MD5",
  "TLS_RSA_WITH_NULL_SHA",
);


sub test {
  print "CLASSPATH=$ENV{'CLASSPATH'}\n";
  print "LD_LIBRARY_PATH=$ENV{LD_LIBRARY_PATH}\n";
  &test_ca if $TESTS{'ca'};
  &self if $TESTS{'self'};
  &openssl_compat if $TESTS{'openssl'};
  &check_other_sites if $TESTS{'other'};
}

if(!$opt_n){
  $opt_c=1 unless $opt_c;
    
  while($opt_c--){
    &test;
  }
}
if($opt_n || $opt_f){
  $ENV{'CLASSPATH'}="$CLASSPATH:$GONATIVEDIR/gonative.jar";
  $ENV{'LD_LIBRARY_PATH'}.=":$GONATIVEDIR";
  print "Testing with GNP\n";
  &test;
}



print "Success\n";
