/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;

public class DmdbBFile
implements Serializable {
    private static final long serialVersionUID = 6324763666783931674L;
    private String gn;
    private String fileName;
    private String go;

    public DmdbBFile(String string) {
        String[] stringArray;
        if (!DmdbBFile.isValidBFileStr(string)) {
            DBError.ECJDBC_INVALID_BFILE.throwException(new String[0]);
        }
        if ((stringArray = string.split(":")).length > 2) {
            this.init(stringArray[0], stringArray[1], stringArray[2]);
        } else {
            this.init(stringArray[0], stringArray[1], null);
        }
    }

    public DmdbBFile(String string, String string2) {
        new DmdbBFile(String.valueOf(string) + ":" + string2);
    }

    protected void init(String string, String string2, String string3) {
        this.gn = string;
        this.fileName = string2;
        this.go = string3;
    }

    public static boolean isValidBFileStr(String string) {
        if (StringUtil.isEmpty(string = string.trim())) {
            return false;
        }
        String[] stringArray = string.split(":");
        return stringArray.length >= 2 && stringArray.length <= 3 && stringArray[0].length() <= 128 && stringArray[1].length() <= 256;
    }

    public String getFileId() {
        return this.go;
    }

    public void setFileId(String string) {
        this.go = string;
    }

    public void setDir(String string) {
        this.gn = string;
    }

    public String getDir() {
        return this.gn;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullName() {
        if (this.isNull()) {
            return "";
        }
        if (StringUtil.isNotEmpty(this.go)) {
            return String.valueOf(this.getDir()) + ":" + this.getFileName() + ":" + this.go;
        }
        return String.valueOf(this.getDir()) + ":" + this.getFileName();
    }

    public boolean isNull() {
        return StringUtil.isEmpty(this.gn) || StringUtil.isEmpty(this.fileName);
    }

    public String toString() {
        return this.getFullName();
    }
}

