/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.convert;

import dm.jdbc.convert.OffRowData;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ConvertUtil;
import java.nio.charset.Charset;
import java.sql.Blob;

public class OffRowBlobData
extends OffRowData {
    public OffRowBlobData(Blob blob, Charset charset) {
        super(blob, charset, -1L);
        this.init();
    }

    @Override
    public void read(ByteArrayQueue byteArrayQueue) {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArrayQueue);
        } else if (!this.readOver) {
            Blob blob = (Blob)this.obj;
            long l2 = blob.length();
            long l3 = l2 - this.position;
            int n2 = (int)(l3 > (long)READ_LEN ? (long)READ_LEN : l3);
            byte[] byArray = blob.getBytes(this.position + 1L, n2);
            this.position += (long)n2;
            if (this.position == l2) {
                this.readOver = true;
            }
            byteArrayQueue.putBytes(byArray, 0, byArray.length);
        }
    }

    @Override
    public byte[] readAll() {
        Blob blob = (Blob)this.obj;
        return ConvertUtil.getBlobData(blob);
    }
}

