package com.ejianc.business.asset.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.asset.vo.PricePublishDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 价格发布主表
 * 
 * @author generator
 * 
 */
public class PricePublishVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人编码
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long orgId; // 组织Id
    private String orgName; // 组织名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date publishDate; // 编制日期
    private String remark; // 备注
    private Integer sourceType; // 1新增/2参照往期
    private Integer enabled; // 0停用1启用
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billDate; // 编制日期
    
    private List<PricePublishDetailVO> pricePublishDetail = new ArrayList<>(); // 价格发布子表





    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }


    /**
     * 提交日期
     */
    public java.util.Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(java.util.Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人编码
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人编码
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 组织Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public java.util.Date getPublishDate() {
        return publishDate;
    }

    /**
     * 编制日期
     */
    public void setPublishDate(java.util.Date publishDate) {
        this.publishDate = publishDate;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 1新增/2参照往期
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 1新增/2参照往期
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 0停用1启用
     */
    public Integer getEnabled() {
        return enabled;
    }

    /**
     * 0停用1启用
     */
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public List<PricePublishDetailVO> getPricePublishDetail() {
        return pricePublishDetail;
    }

    public void setPricePublishDetail(List<PricePublishDetailVO> pricePublishDetail) {
        this.pricePublishDetail = pricePublishDetail;
    }
}
