package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.DateFormater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.List;

@Service("order") 
public class OrderBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOrderService service;
	@Autowired
	private IGoodsService goodsService;
	@Autowired
	private SessionManager sessionManager;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("订单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		if(BillStateEnum.UNAPPROVED.getBillStateCode() == state){
			OrderEntity entity = service.getById(billId);
			GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());
			if (BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums()) >= 0) {
				LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
				lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
				lambdachange.eq(OrderEntity::getGoodsId, entity.getGoodsId());
				lambdachange.eq(OrderEntity::getType, 0);
				lambdachange.ne(OrderEntity::getId, entity.getId());
				List<OrderEntity> list = service.list(lambdachange);
				if (null == list || list.size() <= 0) {
					//需下架
					goodsEntity.setStatus(1);//下架
					goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
					goodsEntity.setLower(InvocationInfoProxy.getUserid());
					goodsEntity.setLowerTime(DateFormater.getCurrentDate());
				} else {
					// to do 还原金额
					BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
					BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();

					goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
					goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
				}
			} else {
				// to do 还原金额
				BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
				BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();

				goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
				goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
			}
			goodsService.saveOrUpdate(goodsEntity, false);
			entity.setType(2); //0-待确认，1-已完成，2-订单取消
			entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
			entity.setCancelName(sessionManager.getUserContext().getUserName());
			entity.setCancelType(3);//取消类型，0=买家，1=卖家，2-超时,3-审批驳回取消
			entity.setCancelTime(DateFormater.getCurrentDate());
			service.saveOrUpdate(entity, false);
		}
		return CommonResponse.success();
	}
}
