package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ICheckService;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.util.MathUtil;
import com.ejianc.business.asset.vo.CheckDetailVO;
import com.ejianc.business.asset.vo.MaterialDealDetailVO;
import com.ejianc.business.asset.vo.RecordVO;
import com.ejianc.business.asset.vo.TurnoverRecordVO;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 周转记录
 *
 * @author generator
 */
@Controller
@RequestMapping("turnoverRecord")
public class TurnoverRecordController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITurnoverRecordService service;

    @Autowired
    private IGoodsService iGoodsService;

    @Autowired
    private ICheckService iCheckService;

    @Autowired
    private IAllotService iAllotService;

    @Autowired
    private IMaterialDealService iMaterialDealService;

    @Autowired
    IMaterialApi materialApi;

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @description: 在场物资参照树结构
     * @return: java.util.List<java.util.Map < java.lang.String, java.lang.Object>>
     * @author songlx
     * @date: 2021-05-11
     */
    @RequestMapping(value = "/treeMaterial", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> treeMaterialList(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                      @RequestParam(defaultValue = "10") Integer pageSize,
                                                      @RequestParam(value = "condition", required = false) String condition,
                                                      @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("materialTypeName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("assetCode")) {
                String assetCode = conditionMap.get("assetCode").toString();
                param.getParams().put("assetCode", new Parameter(QueryParam.EQ, assetCode));
            }
            if (null != conditionMap.get("assetType")) {
                Integer assetType = Integer.valueOf(conditionMap.get("assetType").toString());
                param.getParams().put("assetType", new Parameter(QueryParam.EQ, assetType));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }
            if (null != conditionMap.get("belongType")) {
                Integer belongType = Integer.valueOf(conditionMap.get("belongType").toString());
                param.getParams().put("belongType", new Parameter(QueryParam.EQ, belongType));
            }
            if (null != conditionMap.get("assetBelongType")) {
                Integer assetBelongType = Integer.valueOf(conditionMap.get("assetBelongType").toString());
                param.getParams().put("assetBelongType", new Parameter(QueryParam.EQ, assetBelongType));
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<TurnoverRecordVO> list = service.queryMaterialTreeRef(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            List<Long> materialTypeIds = list.stream().map(TurnoverRecordVO::getMaterialTypeId).collect(Collectors.toList());
            CommonResponse<List<MaterialCategoryVO>> categoryList = materialApi.queryCategoryListByChildren(materialTypeIds);
            List<MaterialCategoryVO> data = categoryList.getData();
            List<Map> resultMapList = BeanMapper.mapList(data, Map.class);
            return ResultAsTree.createTreeData(resultMapList);
        }
        return null;
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param relyCondition
     * @param searchText
     * @description: 在场物资参照 表
     * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.asset.vo.TurnoverRecordVO>>
     * @author songlx
     * @date: 2021-05-11
     */
    @RequestMapping(value = "/onMaterialList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TurnoverRecordVO>> onMaterialList(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                  @RequestParam(defaultValue = "10") Integer pageSize,
                                                                  @RequestParam(value = "condition", required = false) String condition,
                                                                  @RequestParam(value = "relyCondition", required = false) String relyCondition,
                                                                  @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("assetCode", "materialCode", "materialName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("assetCode")) {
                String assetCode = conditionMap.get("assetCode").toString();
                param.getParams().put("assetCode", new Parameter(QueryParam.EQ, assetCode));
            }
            if (null != conditionMap.get("assetType")) {
                Integer assetType = Integer.valueOf(conditionMap.get("assetType").toString());
                param.getParams().put("assetType", new Parameter(QueryParam.EQ, assetType));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }

            if (null != conditionMap.get("belongType")) {
                Integer belongType = Integer.valueOf(conditionMap.get("belongType").toString());
                param.getParams().put("belongType", new Parameter(QueryParam.EQ, belongType));
            }
            if (null != conditionMap.get("assetBelongType")) {
                Integer assetBelongType = Integer.valueOf(conditionMap.get("assetBelongType").toString());
                param.getParams().put("assetBelongType", new Parameter(QueryParam.EQ, assetBelongType));
            }
            if (null != conditionMap.get("materialTypeId")) {
                Long materialTypeId = Long.valueOf(conditionMap.get("materialTypeId").toString());

            }
        }
        if (StringUtils.isNotBlank(relyCondition)) {
            Long materialTypeId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("materialTypeId", new Parameter(QueryParam.EQ, materialTypeId));
        }

        Page<TurnoverRecordVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<TurnoverRecordVO> list = service.queryMaterialRef(page, wrapper);
        IPage<TurnoverRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param param
     * @description: 查询周转记录
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.asset.vo.RecordVO>
     * @author songlx
     * @date: 2021-05-11
     */
    @RequestMapping(value = "/queryRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecordVO> queryRecord(@RequestBody QueryParam param) {
        Parameter orgId = param.getParams().get("orgId");
        Long orgIdValue = (orgId != null && orgId.getValue() != null) ? Long.valueOf(String.valueOf(orgId.getValue())) : null;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", QueryParam.ASC);
        //记录不根据当前机构有关，查询所有该资产id 的记录，在场数量和吨位利旧和当前项目有关
        param.getParams().remove("orgId");
        List<TurnoverRecordEntity> turnoverRecordEntities = service.queryList(param, false);
        List<TurnoverRecordVO> turnoverRecordVOS = BeanMapper.mapList(turnoverRecordEntities, TurnoverRecordVO.class);
        RecordVO recordVO = new RecordVO();
        if (CollectionUtil.isNotEmpty(turnoverRecordVOS)) {
            recordVO.setAssetCode(turnoverRecordVOS.get(0).getAssetCode());
            recordVO.setAssetType(turnoverRecordVOS.get(0).getAssetType());
            //1台车 0周转材
            if (1 == recordVO.getAssetType()) {
                for (TurnoverRecordVO t : turnoverRecordVOS) {
                    if (t.getTon() != null) {
                        recordVO.setTon(t.getTon());
                    }
                    if (t.getUseAssetCode() != null) {
                        recordVO.setUseAssetCode(t.getUseAssetCode());
                        recordVO.setUseTon(t.getUseTon());
                        recordVO.setUseAssetId(t.getUseAssetId());
                    }

                }
            } else {
                BigDecimal onNum = BigDecimal.ZERO;
                BigDecimal dealNum = BigDecimal.ZERO;
                BigDecimal buyNum = BigDecimal.ZERO;
                for (TurnoverRecordVO t : turnoverRecordVOS) {
                    if (t.getOrgId().equals(orgIdValue)) {
                        if (t.getSourceType() != null && (TurnoverTypeEnum.公司自采验收.getCode().equalsIgnoreCase(t.getSourceType()) || (TurnoverTypeEnum.项目自采验收.getCode().equalsIgnoreCase(t.getSourceType())))) {
                            buyNum = buyNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                        }
                        onNum = onNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                        if (t.getSourceType() != null && (TurnoverTypeEnum.公司资产处置.getCode().equalsIgnoreCase(t.getSourceType()) || (TurnoverTypeEnum.项目资产处置.getCode().equalsIgnoreCase(t.getSourceType())))) {
                            dealNum = dealNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                        }
                    }
                }
                recordVO.setBuyNum(buyNum);
                recordVO.setOnNum(onNum);
                recordVO.setDealNum(dealNum.abs());
            }
            recordVO.setTurnoverRecords(turnoverRecordVOS);
        }


        return CommonResponse.success("查询周转记录成功！", recordVO);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TurnoverRecordVO> saveOrUpdate(@RequestBody TurnoverRecordVO saveorUpdateVO) {
        TurnoverRecordEntity entity = BeanMapper.map(saveorUpdateVO, TurnoverRecordEntity.class);
        service.saveOrUpdate(entity, false);
        TurnoverRecordVO vo = BeanMapper.map(entity, TurnoverRecordVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TurnoverRecordVO> queryDetail(Long id) {
        TurnoverRecordEntity entity = service.selectById(id);
        TurnoverRecordVO vo = BeanMapper.map(entity, TurnoverRecordVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TurnoverRecordVO> vos) {
        service.removeByIds(vos.stream().map(TurnoverRecordVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TurnoverRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<TurnoverRecordEntity> page = service.queryPage(param, false);
        IPage<TurnoverRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TurnoverRecordVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param projectId
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetailProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDetailProject(@RequestParam(value = "projectId")Long projectId,
                                                               @RequestParam(value = "orgId")Long orgId,
                                                               @RequestParam(value = "materialCode")String materialCode) {
        List<JSONObject> voList = new ArrayList<JSONObject>();
        List<TurnoverRecordVO> turnoverRecordVOList =service.selectByProjectId(projectId,orgId);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            JSONObject vo = new JSONObject();
            vo.put("projectId", projectId);
            vo.put("orgId", orgId);
            if (turnoverRecordVO.getAssetType()!=null){
                vo.put("assetType",turnoverRecordVO.getAssetType()==0?"周转材":"台车");
            }
            vo.put("spec", turnoverRecordVO.getSpec());
            vo.put("unit", turnoverRecordVO.getUnit());
            vo.put("materialName", turnoverRecordVO.getMaterialName());
            if (!(materialCode==null || "".equals(materialCode))){
                if (!turnoverRecordVO.getMaterialCode().equals(materialCode)){
                    continue;
                }
            }
            vo.put("sumNum", turnoverRecordVO.getSumNum());
            vo.put("projectName",turnoverRecordVO.getProjectName());
            List<GoodsVO> goodsVOList = iGoodsService.selectDetail(projectId,orgId,turnoverRecordVO.getMaterialName());
            if (goodsVOList!=null && !goodsVOList.isEmpty()) {
                for (GoodsVO goodsVO : goodsVOList) {
                    vo.put("rotatableNums", goodsVO.getRotatableNums());
                    vo.put("rotatableMoney", MathUtil.safeMultiply(goodsVO.getPrice(), goodsVO.getRotatableNums()));
                }
            }
            List<TurnoverRecordVO> turnoverRecordVO1 =service.selectByName(projectId,orgId,turnoverRecordVO.getMaterialName());
            for (TurnoverRecordVO recordVO : turnoverRecordVO1) {
                if ("自采验收".equals(recordVO.getSourceTypeName())){
                    vo.put("checkNum",  recordVO.getNum());
                    vo.put("checkTaxMoney", recordVO.getTotalMoney());
                }
                if ("资产调拨".equals(recordVO.getSourceTypeName())){
                    vo.put("allotNum", recordVO.getNum());
                    vo.put("allotMoney", recordVO.getTotalMoney());
                }
                if ("".equals(orgId)||orgId==null){
                    if ("租赁验收".equals(recordVO.getSourceTypeName())){
                        vo.put("rentNum",  recordVO.getNum());
                        vo.put("rentMoney", recordVO.getTotalMoney());
                    }
                }else {
                    if ("资产租赁".equals(recordVO.getSourceTypeName())){
                        vo.put("rentNum",  recordVO.getNum());
                        vo.put("rentMoney", recordVO.getTotalMoney());
                    }
                }
                if ("资产回收".equals(recordVO.getSourceTypeName())){
                    vo.put("recoverNum", recordVO.getNum());
                    vo.put("recoverMoney", recordVO.getTotalMoney());
                }
                if ("资产处置".equals(recordVO.getSourceTypeName())){
                    vo.put("dealNum", recordVO.getNum());
                    vo.put("dealMoney", recordVO.getTotalMoney());
                }
            }
            AllotVO allotVO = iAllotService.selectByMaterialName(projectId,orgId,turnoverRecordVO.getMaterialName());
            if (!(allotVO == null || "".equals(allotVO))){
                vo.put("nums", allotVO.getNums());
                vo.put("amount", allotVO.getAmount());
            }
            voList.add(vo);
        }
        return CommonResponse.success("查询详情数据成功！", voList);
    }

    /**
     * @param projectId
     * @Description queryDetail 查询详情明细
     */
    @RequestMapping(value = "/queryDetailProjectDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDetailProjectDetail(@RequestParam(value = "projectId")Long projectId,
                                                                     @RequestParam(value = "orgId")Long orgId,
                                                                     @RequestParam(value = "materialName")String materialName) {
        List<JSONObject> voList = new ArrayList<JSONObject>();
        List<TurnoverRecordVO> turnoverRecordVOList =service.selectDetail(projectId,orgId,materialName);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            JSONObject vo = new JSONObject();
            vo.put("projectId", projectId);
            vo.put("orgId", orgId);
            if (turnoverRecordVO.getAssetType()!=null){
                vo.put("assetType",turnoverRecordVO.getAssetType()==0?"周转材":"台车");
            }
            vo.put("assetCode",turnoverRecordVO.getAssetCode());
            vo.put("materialName",turnoverRecordVO.getMaterialName());
            vo.put("spec",turnoverRecordVO.getSpec() );
            vo.put("unit",turnoverRecordVO.getUnit() );
            vo.put("num",turnoverRecordVO.getNum());
            vo.put("totalMoney",turnoverRecordVO.getTotalMoney());
            vo.put("sourceTypeName",turnoverRecordVO.getSourceTypeName());
            if ("自采验收".equals(turnoverRecordVO.getSourceTypeName())){
            }else {
                if ("资产回收".equals(turnoverRecordVO.getSourceTypeName())) {
                    List<GoodsVO> goodsList = iGoodsService.selectDetail(projectId, orgId, turnoverRecordVO.getMaterialName());
                    for (GoodsVO goodsVO : goodsList) {
                        List<AllotVO> allotVOList = iAllotService.queryDetail(goodsVO.getId(), turnoverRecordVO.getMaterialName());
                        for (AllotVO allotVO : allotVOList) {
                            if ("".equals(orgId)) {
                                vo.put("sellProjectName", allotVO.getBuyProjectName());
                                vo.put("buyProjectName", allotVO.getSellProjectName());
                            } else {
                                vo.put("sellOrgName", allotVO.getBuyOrgName());
                                vo.put("buyOrgName", allotVO.getSellOrgName());
                            }
                        }
                    }
                } else {
                    List<GoodsVO> goodsList = iGoodsService.selectDetail(projectId, orgId, turnoverRecordVO.getMaterialName());
                    for (GoodsVO goodsVO : goodsList) {
                        List<AllotVO> allotVOList = iAllotService.queryDetail(goodsVO.getId(), turnoverRecordVO.getMaterialName());
                        for (AllotVO allotVO : allotVOList) {
                            if ("".equals(orgId)) {
                                vo.put("buyProjectName", allotVO.getBuyProjectName());
                                vo.put("sellProjectName", allotVO.getSellProjectName());
                            } else {
                                vo.put("buyOrgName", allotVO.getBuyOrgName());
                                vo.put("sellOrgName", allotVO.getSellOrgName());
                            }
                        }
                    }
                }
            }
            voList.add(vo);
        }
        return CommonResponse.success("查询详情数据成功！", voList);
    }

    /**
     * @param projectId
     * @Description queryDetail 穿透查询详情明细
     */
    @RequestMapping(value = "/queryDetailDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryDetailDetail(@RequestParam(value = "projectId")Long projectId,
                                                              @RequestParam(value = "orgId")Long orgId,
                                                              @RequestParam(value = "materialName")String materialName) {
        List<JSONObject> voList = new ArrayList<JSONObject>();
        if (("".equals(orgId) || orgId==null)&&("".equals(projectId) || projectId==null)){
            List<TurnoverRecordVO> turnoverRecordVOList = service.selectDetail(materialName);
            for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
                JSONObject vo = new JSONObject();
                if (turnoverRecordVO.getAssetType()!=null){
                    vo.put("assetType",turnoverRecordVO.getAssetType()==0?"周转材":"台车");
                }
                vo.put("assetCode",turnoverRecordVO.getAssetCode());
                vo.put("materialName",turnoverRecordVO.getMaterialName());
                vo.put("spec",turnoverRecordVO.getSpec());
                vo.put("checkNum", turnoverRecordVO.getNum());
                List<GoodsVO> goodsList = iGoodsService.selectDetail(projectId,orgId,turnoverRecordVO.getMaterialName());
                for (GoodsVO goodsVO : goodsList) {
                    List<AllotVO> allotVOList = iAllotService.queryDetail(goodsVO.getId(),turnoverRecordVO.getMaterialName());
                    for (AllotVO allotVO : allotVOList) {
                        vo.put("buyOrgName",allotVO.getBuyOrgName());
                    }
                }
                voList.add(vo);
            }
            return CommonResponse.success("查询详情数据成功！", voList);
        }
        List<TurnoverRecordVO> turnoverRecordVOList = service.selectDetail(projectId,orgId,materialName);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            JSONObject vo = new JSONObject();
            vo.put("orgId", orgId);
            if (turnoverRecordVO.getAssetType()!=null){
                vo.put("assetType",turnoverRecordVO.getAssetType()==0?"周转材":"台车");
            }
            vo.put("assetCode",turnoverRecordVO.getAssetCode());
            vo.put("materialName",turnoverRecordVO.getMaterialName());
            vo.put("spec",turnoverRecordVO.getSpec());
            if (!"资产租赁".equals(turnoverRecordVO.getSourceTypeName())){
                continue;
            }
            vo.put("checkNum", turnoverRecordVO.getNum());
            List<GoodsVO> goodsList = iGoodsService.selectDetail(projectId,orgId,turnoverRecordVO.getMaterialName());
            for (GoodsVO goodsVO : goodsList) {
                List<AllotVO> allotVOList = iAllotService.queryDetail(goodsVO.getId(),turnoverRecordVO.getMaterialName());
                for (AllotVO allotVO : allotVOList) {
                    vo.put("buyOrgName",allotVO.getBuyOrgName());
                }
            }
            voList.add(vo);
        }
        return CommonResponse.success("查询详情数据成功！", voList);
    }
    /**
     * @param projectId
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryProjectDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryProjectDetail(@RequestParam(value = "projectId")Long projectId,
                                                               @RequestParam(value = "orgId")Long orgId,
                                                               @RequestParam(value = "materialName")String materialName) {
        List<JSONObject> voList = new ArrayList<JSONObject>();
        List<TurnoverRecordVO> turnoverRecordVOList =service.selectProjectDetail(materialName);
        for (TurnoverRecordVO turnoverRecordVO : turnoverRecordVOList) {
            JSONObject vo = new JSONObject();
            projectId = turnoverRecordVO.getProjectId();
            vo.put("projectId", projectId);
            if (turnoverRecordVO.getAssetType()!=null){
                vo.put("assetType",turnoverRecordVO.getAssetType()==0?"周转材":"台车");
            }
            vo.put("spec", turnoverRecordVO.getSpec());
            vo.put("unit", turnoverRecordVO.getUnit());
            vo.put("materialName", turnoverRecordVO.getMaterialName());
            vo.put("sumNum", turnoverRecordVO.getSumNum());
            vo.put("projectName",turnoverRecordVO.getProjectName());

            List<GoodsVO> goodsVOList = iGoodsService.selectDetail(projectId,orgId,turnoverRecordVO.getMaterialName());
            if (goodsVOList!=null && !goodsVOList.isEmpty()) {
                for (GoodsVO goodsVO : goodsVOList) {
                    vo.put("rotatableNums", goodsVO.getRotatableNums());
                    vo.put("rotatableMoney", MathUtil.safeMultiply(goodsVO.getPrice(), goodsVO.getRotatableNums()));
                }
            }
            List<TurnoverRecordVO> turnoverRecordVO1 =service.selectByName(projectId,orgId,turnoverRecordVO.getMaterialName());
            for (TurnoverRecordVO recordVO : turnoverRecordVO1) {
                if ("自采验收".equals(recordVO.getSourceTypeName())){
                    vo.put("checkNum",  recordVO.getNum());
                    vo.put("checkTaxMoney", recordVO.getTotalMoney());
                }
                if ("资产调拨".equals(recordVO.getSourceTypeName())){
                    vo.put("allotNum", recordVO.getNum());
                    vo.put("allotMoney", recordVO.getTotalMoney());
                }
                if ("".equals(orgId)||orgId==null){
                    if ("租赁验收".equals(recordVO.getSourceTypeName())){
                        vo.put("rentNum",  recordVO.getNum());
                        vo.put("rentMoney", recordVO.getTotalMoney());
                    }
                }else {
                    if ("资产租赁".equals(recordVO.getSourceTypeName())){
                        vo.put("rentNum",  recordVO.getNum());
                        vo.put("rentMoney", recordVO.getTotalMoney());
                    }
                }
                if ("资产回收".equals(recordVO.getSourceTypeName())){
                    vo.put("recoverNum", recordVO.getNum());
                    vo.put("recoverMoney", recordVO.getTotalMoney());
                }
                if ("资产处置".equals(recordVO.getSourceTypeName())){
                    vo.put("dealNum", recordVO.getNum());
                    vo.put("dealMoney", recordVO.getTotalMoney());
                }
            }
            AllotVO allotVO = iAllotService.selectByMaterialName(projectId,orgId,turnoverRecordVO.getMaterialName());
            if (!(allotVO == null || "".equals(allotVO))){
                vo.put("nums", allotVO.getNums());
                vo.put("amount", allotVO.getAmount());
            }
            voList.add(vo);
        }
        return CommonResponse.success("查询详情数据成功！", voList);
    }
}