package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.vo.TurnoverRecordVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.TurnoverRecordMapper;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.service.ITurnoverRecordService;

import java.util.List;

/**
 * 周转记录
 * 
 * @author generator
 * 
 */
@Service("turnoverRecordService")
public class TurnoverRecordServiceImpl extends BaseServiceImpl<TurnoverRecordMapper, TurnoverRecordEntity> implements ITurnoverRecordService{

    @Override
    public List<TurnoverRecordVO> queryMaterialRef(Page<TurnoverRecordVO> page, QueryWrapper wrapper) {
        return baseMapper.queryMaterialRef(page, wrapper);
    }

    @Override
    public List<TurnoverRecordVO> queryMaterialTreeRef(QueryWrapper wrapper) {
        return baseMapper.queryMaterialRef(wrapper);
    }
    @Override
    public List<TurnoverRecordVO> selectByProjectId(Long projectId,Long orgId) {
        return baseMapper.selectByProjectId(projectId,orgId);
    }

    @Override
    public List<TurnoverRecordVO> selectDetail(Long projectId, Long orgId,String materialName) {
        return baseMapper.selectDetail(projectId,orgId,materialName);
    }

    @Override
    public List<TurnoverRecordVO> selectProjectDetail(String materialName) {
        return baseMapper.selectProjectDetail(materialName);
    }

    @Override
    public List<TurnoverRecordVO> selectByName(Long projectId, Long orgId,String materialName) {
        return baseMapper.selectByName(projectId,orgId,materialName);
    }

    @Override
    public List<TurnoverRecordVO> selectDetail(String materialName) {
        return baseMapper.selectByName(materialName);
    }
}
