package com.ejianc.business.asset.service.impl;

import com.ejianc.business.asset.bean.CheckDetailEntity;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ICheckService;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.util.MathUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.ArrayStack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("check") 
public class CheckBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ICheckService checkService;
	@Autowired
	private ITurnoverRecordService turnoverRecordService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		CheckEntity checkEntity= checkService.selectById(billId);
		List<CheckDetailEntity> checkDetail = checkEntity.getCheckDetail();
		List<TurnoverRecordEntity> turnoverRecordEntitList = new ArrayList<>();
		TurnoverRecordEntity turnoverRecordEntity = null;
		for(CheckDetailEntity checkDetailEntity : checkDetail){
			if (checkEntity.getBelongType() == 0 && checkEntity.getCheckType() == 0){
				turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.项目自采验收);
			}

			if (checkEntity.getBelongType() == 0 && checkEntity.getCheckType() == 1){
				turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.调拨验收);
			}
			//checkEntity.getCheckType() == 2  租赁
			if (checkEntity.getBelongType() == 0 && checkEntity.getCheckType() == 2){
				turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.租赁验收);
			}
			if (checkEntity.getBelongType() == 1 && checkEntity.getCheckType() == 0){
				turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.公司自采验收);
			}
			turnoverRecordEntity.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
			turnoverRecordEntity.setMaterialTypeCode(checkDetailEntity.getMaterialTypeCode());
			turnoverRecordEntity.setMaterialTypeId(checkDetailEntity.getMaterialTypeId());
			turnoverRecordEntity.setMaterialCode(checkDetailEntity.getMaterialCode());
			turnoverRecordEntity.setMaterialId(checkDetailEntity.getMaterialId());
			turnoverRecordEntity.setMaterialName(checkDetailEntity.getMaterialName());
			turnoverRecordEntity.setSpec(checkDetailEntity.getSpec());
			turnoverRecordEntity.setUnit(checkDetailEntity.getUnit());
			turnoverRecordEntity.setAssetId(checkDetailEntity.getAssetId());
			turnoverRecordEntity.setAssetCode(checkDetailEntity.getAssetCode());
			turnoverRecordEntity.setAssetType(checkDetailEntity.getAssetType());
			turnoverRecordEntity.setOrgId(checkEntity.getOrgId());
			turnoverRecordEntity.setOrgName(checkEntity.getOrgName());
			turnoverRecordEntity.setProjectId(checkEntity.getProjectId());
			turnoverRecordEntity.setProjectName(checkEntity.getProjectName());
			turnoverRecordEntity.setSourceDate(checkEntity.getCheckDate());
			turnoverRecordEntity.setSourceId(checkEntity.getId());
			turnoverRecordEntity.setSourceDetailId(checkDetailEntity.getId());
			turnoverRecordEntity.setBelongType(checkEntity.getBelongType());
			turnoverRecordEntity.setAssetBelongType(checkDetailEntity.getAssetBelongType());
			turnoverRecordEntity.setBelongOrgId(checkDetailEntity.getBelongOrgId());
			turnoverRecordEntity.setBelongOrgName(checkDetailEntity.getBelongOrgName());
			turnoverRecordEntity.setNum(checkDetailEntity.getCheckNum());
			turnoverRecordEntity.setTon(checkDetailEntity.getCapacity() == null ? checkDetailEntity.getCheckTon() : checkDetailEntity.getCapacity());
			turnoverRecordEntity.setPrice(checkDetailEntity.getAllotPrice());
			turnoverRecordEntity.setTotalMoney(MathUtil.safeMultiply(checkDetailEntity.getCheckNum(),checkDetailEntity.getAllotPrice()));
			turnoverRecordEntitList.add(turnoverRecordEntity);
		}
		turnoverRecordService.saveBatch(turnoverRecordEntitList);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("验收单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
