package com.ejianc.business.panhuo.mapper;

import com.ejianc.business.panhuo.vo.AllotVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.panhuo.bean.AllotEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 调拨单
 * 
 * @author generator
 * 
 */
@Mapper
public interface AllotMapper extends BaseCrudMapper<AllotEntity> {
    @Select("<script>"+
            "SELECT sum(nums) as nums,sum(amount) as amount FROM ejc_panhuo_allot WHERE dr = 0 " +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND sell_project = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND sell_org = #{orgId} " +
            "</if>" +
            "and material_name =#{materialName}"+
            "</script>")
    AllotVO selectByMaterialName(Long projectId,Long orgId, String materialName);
    @Select("SELECT * FROM ejc_panhuo_allot WHERE id =#{id}  and  material_name =#{materialName} AND dr = 0 ")
    List<AllotVO> queryDetail(Long id, String materialName);
    @Select("SELECT * FROM ejc_panhuo_allot WHERE  material_name =#{materialName} AND dr = 0 ")
    List<AllotVO> selectMaterialName(String materialName);
    @Select("SELECT * FROM ejc_panhuo_allot WHERE goods_id =#{id}  and  material_name =#{materialName} AND dr = 0 ")
    List<AllotVO> queryDetailByGoodId(Long id, String materialName);
}
