package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.*;
import com.ejianc.business.asset.service.IPlanService;
import com.ejianc.business.asset.util.MathUtil;
import com.ejianc.business.asset.vo.CheckDetailVO;
import com.ejianc.business.asset.vo.CheckVO;
import com.ejianc.business.asset.vo.PlanVO;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.CheckMapper;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.service.ICheckService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 验收实体
 *
 * @author generator
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService {
    private static final String CRG_PRO_CHECK = "CRG_PRO_CHECK";
    private static final String CRG_ORG_CHECK = "CRG_ORG_CHECK";
    private static final String ASSET_CODE = "ASSET_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAllotService service;

    @Autowired
    private IPlanService planService;

    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Override
    public CommonResponse<CheckVO> saveOrUpdate(CheckVO checkVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty(checkVO.getBillCode())) {
            //区分项目和专业公司单据编码
            CommonResponse<String> billCode = null;
            if (checkVO.getBelongType() == 0) {
                billCode = billCodeApi.getCodeBatchByRuleCode(CRG_PRO_CHECK, tenantId);
            }
            if (checkVO.getBelongType() == 1) {
                billCode = billCodeApi.getCodeBatchByRuleCode(CRG_ORG_CHECK, tenantId);
            }
            if (billCode.isSuccess()) {
                checkVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        CheckEntity entity = BeanMapper.map(checkVO, CheckEntity.class);
        //汇总物资明细名称
        List<CheckDetailEntity> checkDetail = entity.getCheckDetail();
        String materialName = "";
        int count = 0;
        List<String> materialNameList = new ArrayList<>();
        if (checkDetail != null && checkDetail.size() > 0) {
            for (CheckDetailEntity checkDetailEntity : checkDetail) {
                if (null == checkDetailEntity.getAssetCode()) {
                    ++count;
                }

                if (!materialNameList.contains(checkDetailEntity.getMaterialName())) {
                    materialNameList.add(checkDetailEntity.getMaterialName());
                }
            }
        }
        if (count > 0) {
            CommonResponse<List<String>> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId, count);
            List<String> assetCodeList = codeBatchByRuleCode.getData();
            for (String code : assetCodeList) {
                for (CheckDetailEntity checkDetailEntity : checkDetail) {
                    if (null == checkDetailEntity.getAssetCode()) {
                        checkDetailEntity.setAssetCode(code);
                        checkDetailEntity.setAssetId(IdWorker.getId());
                        break;
                    }
                }
            }

        }

        if (materialNameList != null && materialNameList.size() > 0) {
            for (String materialNames : materialNameList) {
                materialName = materialName + materialNames + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        if (null != entity.getAllotId() && 0 != entity.getAllotId()) {
            AllotEntity allotEntity = service.selectById(entity.getAllotId());
            allotEntity.setState(1);
            service.updateById(allotEntity);
        }
        // 回写计划 累计验收数量
        Long planId = entity.getPlanId();
        if (planId != null) {
            PlanEntity planEntity = planService.selectById(planId);
            List<CheckDetailEntity> detail = entity.getCheckDetail();
            List<PlanDetailEntity> planDetail = planEntity.getPlanDetail();
            if (CollectionUtils.isNotEmpty(detail) && CollectionUtils.isNotEmpty(planDetail)) {
                Map<Long, CheckDetailEntity> numMap =
                        detail.stream().collect(Collectors.toMap(CheckDetailEntity::getMaterialId, account -> account));
                boolean isNew = false;
                CheckEntity oldCheck = null;
                if(entity.getId() != null){
                    oldCheck = checkService.selectById(entity.getId());
                    isNew = oldCheck == null;
                }
                if (entity.getId() == null || isNew) {
                    for (PlanDetailEntity p : planDetail) {
                        Long materialId = p.getMaterialId();
                        CheckDetailEntity dec = numMap.get(materialId);
                        if (dec != null && !("del").equals(dec.getRowState())) {
                            BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                            p.setSumNums(_sum.add(dec.getCheckNum()));
                        }
                    }
                } else {
                    if(oldCheck != null){
                        List<CheckDetailEntity> oldDetail = oldCheck.getCheckDetail();
                        Map<Long, CheckDetailEntity> oldMap = new HashMap<>();
                        if (CollectionUtils.isNotEmpty(oldDetail)) {
                            oldMap = oldDetail.stream().collect(Collectors.toMap(CheckDetailEntity::getMaterialId, account -> account));
                        }
                        //修改
                        for (PlanDetailEntity p : planDetail) {
                            Long materialId = p.getMaterialId();
                            CheckDetailEntity dec = numMap.get(materialId);
                            if (dec != null) {
                                //新增
                                if (dec.getId() == null) {
                                    if (("add").equals(dec.getRowState())) {
                                        BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                                        p.setSumNums(_sum.add(dec.getCheckNum()));
                                    }
                                } else {
                                    if (("del").equals(dec.getRowState())) {
                                        CheckDetailEntity old = oldMap.get(materialId);
                                        BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                                        p.setSumNums(_sum.subtract(old.getCheckNum()));
                                    } else {
                                        CheckDetailEntity old = oldMap.get(materialId);
                                        BigDecimal subtract = dec.getCheckNum().subtract(old.getCheckNum());
                                        BigDecimal _sum = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                                        p.setSumNums(_sum.add(subtract));
                                    }
                                }
                            }
                        }
                    }
                }

            }
            BigDecimal _sumNums = BigDecimal.ZERO;
            BigDecimal _nums = BigDecimal.ZERO;

            for (PlanDetailEntity p : planDetail) {
                if (p.getSumNums() != null && p.getSumNums().compareTo(p.getNums()) > 0) {
                    return CommonResponse.success("物资【" + p.getMaterialName() + "】累计验收数量已超计划数量，不允许保存！");
                }
                _sumNums = MathUtil.safeAdd(_sumNums, p.getSumNums());
                _nums = MathUtil.safeAdd(_nums, p.getNums());
            }

            planEntity.setCheckState(_sumNums.compareTo(_nums) == 0  ? 1 : 0);
            planService.saveOrUpdate(planEntity, false);
        }
        checkService.saveOrUpdate(entity, false);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<CheckVO> copyCheckFile(Long goodsId) {
        Long id = IdWorker.getId();
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                goodsId.toString(),
                "BT210510000000005",
                "drawingUpload",
                id.toString(),
                "BT210508000000002",
                "drawingUpload"
        );
        if (!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        CheckVO checkVO = new CheckVO();
        checkVO.setId(id);
        CommonResponse<List<AttachmentVO>> listCommonResponse = iAttachmentApi.queryListBySourceId(id, "BT210508000000002", "drawingUpload", null);
        if(listCommonResponse.isSuccess()){
            checkVO.setFileList(listCommonResponse.getData());
        }
        return CommonResponse.success("附件复制成功！", checkVO);
    }

    @Override
    public CommonResponse<CheckVO> copyPlanFile(Long planId, CheckVO checkVO) {
        Long id = IdWorker.getId();
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                planId.toString(),
                "BT210508000000001",
                "drawingUpload",
                id.toString(),
                "BT210508000000002",
                "drawingUpload"
        );
        if (!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        checkVO.setId(id);
        CommonResponse<List<AttachmentVO>> listCommonResponse = iAttachmentApi.queryListBySourceId(id, "BT210508000000002", "drawingUpload", null);
        if(listCommonResponse.isSuccess()){
            checkVO.setFileList(listCommonResponse.getData());
        }

        return CommonResponse.success("附件复制成功！", checkVO);
    }
    @Override
    public List<CheckDetailVO> selectByMaterialName(Long checkId, String materialName) {
        return baseMapper.selectByMaterialName(checkId,materialName);
    }

    @Override
    public List<Long> selectCheckId(Long projectId,Long orgId) {
        return baseMapper.selectCheckId(projectId,orgId);
    }

    @Override
    public List<Long> selectAllotId(Long projectId,Long orgId) {
        return baseMapper.selectAllotId(projectId,orgId);
    }

}
