package com.ejianc.business.panhuo.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_panhuo_order")
public class OrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="goods_id")
    private Long goodsId; // 资产主键
    @TableField(value="bill_code")
    private String billCode; // 订单编号
    @TableField(value="asset_code")
    private String assetCode; // 资产编码
    @TableField(value="asset_id")
    private Long assetId; // 物资主键
    @TableField(value="capacity")
    private java.math.BigDecimal capacity; // 承载量
    @TableField(value="asset_belong_type")
    private Integer assetBelongType; // 资产归属 0-项目，1-公司
    @TableField(value="belong_org_id")
    private Long belongOrgId; // 归属公司主键
    @TableField(value="belong_org_name")
    private String belongOrgName; // 归属公司名称
    @TableField(value="tool_id")
    private Long toolId; // 机具主键
    @TableField(value="material_id")
    private Long materialId; // 物资主键
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物资编号
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资类别
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资类别编号
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资类别名称
    @TableField(value="asset_type")
    private Integer assetType; // 物资类型 0-周转材，1-台车
    @TableField(value="source_id")
    private String sourceId; // 物资来源ID
    @TableField(value="system_id")
    private Long systemId; // 所属系统ID
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="mainimg_path")
    private String mainimgPath; // 资产主图URL
    @TableField(value="type")
    private Integer type; // 0-待确认，1-已完成，2-订单取消
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="orderprice")
    private java.math.BigDecimal orderprice; // 单价
    @TableField(value="ordernums")
    private java.math.BigDecimal ordernums; // 数量
    @TableField(value="ordermny")
    private java.math.BigDecimal ordermny; // 下单金额
    @TableField(value="price")
    private java.math.BigDecimal price; // 成交单价
    @TableField(value="originalprice")
    private java.math.BigDecimal originalprice; // 原价
    @TableField(value="discount")
    private java.math.BigDecimal discount; // 折扣
    @TableField(value="nums")
    private java.math.BigDecimal nums; // 成交数量
    @TableField(value="mny")
    private java.math.BigDecimal mny; // 成交金额
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="buy_time")
    private Date buyTime; // 购买时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="dealr_time")
    private java.util.Date dealrTime; // 成交时间
    @TableField(value="order_user_id")
    private Long orderUserId; // 订购人
    @TableField(value="order_user_name")
    private String orderUserName; // 订购人名称
    @TableField(value="confirmer")
    private Long confirmer; // 确认人
    @TableField(value="confirmer_name")
    private String confirmerName; // 确认人名称
    @TableField(value="belong_type")
    private Integer belongType; // 出售方类型 0=项目，1=公司
    @TableField(value="seller")
    private Long seller; // 资产发布人
    @TableField(value="seller_name")
    private String sellerName; // 资产发布人名称
    @TableField(value="sell_org")
    private Long sellOrg; // 出售方组织主键
    @TableField(value="sell_org_name")
    private String sellOrgName; // 出售方组织名称
    @TableField(value="sell_project")
    private Long sellProject; // 出售方项目
    @TableField(value="sell_project_name")
    private String sellProjectName; // 出售方项目名称
    @TableField(value="sell_address_id")
    private Long sellAddressId; // 出售方地址主键
    @TableField(value="sell_address")
    private String sellAddress; // 出售方详细地址
    @TableField(value="sell_user_name")
    private String sellUserName; // 出售方联系人
    @TableField(value="sell_phone")
    private String sellPhone; // 出售方联系电话
    @TableField(value="buyer")
    private String buyer; // 购买方联系人
    @TableField(value="buy_org")
    private Long buyOrg; // 购买方组织主键
    @TableField(value="buy_org_name")
    private String buyOrgName; // 购买方组织名称
    @TableField(value="buy_project")
    private Long buyProject; // 购买方项目主键
    @TableField(value="buy_project_name")
    private String buyProjectName; // 购买方项目名称
    @TableField(value="buy_address_id")
    private Long buyAddressId; // 购买方地址主键
    @TableField(value="buy_address")
    private String buyAddress; // 购买方详细地址
    @TableField(value="buy_phone")
    private String buyPhone; // 购买方电话
    @TableField(value="is_pack")
    private String isPack; // 0-是  1-否
    @TableField(value="cancel")
    private String cancel; // 取消人
    @TableField(value="cancel_name")
    private java.lang.String cancelName; // 取消人
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="cancel_time")
    private java.util.Date cancelTime; // 取消时间
    @TableField(value="cancel_type")
    private Integer cancelType; // 取消类型，0=买家，1=卖家，2-超时,3-审批驳回取消
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="confirm_name")
    private String confirmName; // 确认人名称
    @TableField(value="shelf_type")
    private String shelfType; // 资产类型
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="shelf_time")
    private java.util.Date shelfTime; // 上架时间
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value="order_type")
    private java.lang.Integer orderType; // 订单类型 0-调拨下单，1-租赁下单

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }
    

    /**
     * 资产主键
     */
    public Long getGoodsId() {
        return goodsId;
    }

    /**
     * 资产主键
     */
    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }
    /**
     * 订单编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 订单编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    /**
     * 物资主键
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 物资主键
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    /**
     * 承载量
     */
    public java.math.BigDecimal getCapacity() {
        return capacity;
    }

    /**
     * 承载量
     */
    public void setCapacity(java.math.BigDecimal capacity) {
        this.capacity = capacity;
    }
    /**
     * 资产归属 0-项目，1-公司
     */
    public Integer getAssetBelongType() {
        return assetBelongType;
    }

    /**
     * 资产归属 0-项目，1-公司
     */
    public void setAssetBelongType(Integer assetBelongType) {
        this.assetBelongType = assetBelongType;
    }
    /**
     * 归属公司主键
     */
    public Long getBelongOrgId() {
        return belongOrgId;
    }

    /**
     * 归属公司主键
     */
    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }
    /**
     * 归属公司名称
     */
    public String getBelongOrgName() {
        return belongOrgName;
    }

    /**
     * 归属公司名称
     */
    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }
    /**
     * 机具主键
     */
    public Long getToolId() {
        return toolId;
    }

    /**
     * 机具主键
     */
    public void setToolId(Long toolId) {
        this.toolId = toolId;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编号
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编号
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别编号
     */
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    /**
     * 物资类别编号
     */
    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资类型 0-周转材，1-台车
     */
    public Integer getAssetType() {
        return assetType;
    }

    /**
     * 物资类型 0-周转材，1-台车
     */
    public void setAssetType(Integer assetType) {
        this.assetType = assetType;
    }
    /**
     * 物资来源ID
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 物资来源ID
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 所属系统ID
     */
    public Long getSystemId() {
        return systemId;
    }

    /**
     * 所属系统ID
     */
    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 资产主图URL
     */
    public String getMainimgPath() {
        return mainimgPath;
    }

    /**
     * 资产主图URL
     */
    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    /**
     * 0-待确认，1-已完成，2-订单取消
     */
    public Integer getType() {
        return type;
    }

    /**
     * 0-待确认，1-已完成，2-订单取消
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单价
     */
    public java.math.BigDecimal getOrderprice() {
        return orderprice;
    }

    /**
     * 单价
     */
    public void setOrderprice(java.math.BigDecimal orderprice) {
        this.orderprice = orderprice;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getOrdernums() {
        return ordernums;
    }

    /**
     * 数量
     */
    public void setOrdernums(java.math.BigDecimal ordernums) {
        this.ordernums = ordernums;
    }
    /**
     * 下单金额
     */
    public java.math.BigDecimal getOrdermny() {
        return ordermny;
    }

    /**
     * 下单金额
     */
    public void setOrdermny(java.math.BigDecimal ordermny) {
        this.ordermny = ordermny;
    }
    /**
     * 成交单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 成交单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 原价
     */
    public java.math.BigDecimal getOriginalprice() {
        return originalprice;
    }

    /**
     * 原价
     */
    public void setOriginalprice(java.math.BigDecimal originalprice) {
        this.originalprice = originalprice;
    }
    /**
     * 折扣
     */
    public java.math.BigDecimal getDiscount() {
        return discount;
    }

    /**
     * 折扣
     */
    public void setDiscount(java.math.BigDecimal discount) {
        this.discount = discount;
    }
    /**
     * 成交数量
     */
    public java.math.BigDecimal getNums() {
        return nums;
    }

    /**
     * 成交数量
     */
    public void setNums(java.math.BigDecimal nums) {
        this.nums = nums;
    }
    /**
     * 成交金额
     */
    public java.math.BigDecimal getMny() {
        return mny;
    }

    /**
     * 成交金额
     */
    public void setMny(java.math.BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 购买时间
     */
    public java.util.Date getBuyTime() {
        return buyTime;
    }

    /**
     * 购买时间
     */
    public void setBuyTime(java.util.Date buyTime) {
        this.buyTime = buyTime;
    }
    /**
     * 成交时间
     */
    public java.util.Date getDealrTime() {
        return dealrTime;
    }

    /**
     * 成交时间
     */
    public void setDealrTime(java.util.Date dealrTime) {
        this.dealrTime = dealrTime;
    }
    /**
     * 订购人
     */
    public Long getOrderUserId() {
        return orderUserId;
    }

    /**
     * 订购人
     */
    public void setOrderUserId(Long orderUserId) {
        this.orderUserId = orderUserId;
    }
    /**
     * 订购人名称
     */
    public String getOrderUserName() {
        return orderUserName;
    }

    /**
     * 订购人名称
     */
    public void setOrderUserName(String orderUserName) {
        this.orderUserName = orderUserName;
    }
    /**
     * 确认人
     */
    public Long getConfirmer() {
        return confirmer;
    }

    /**
     * 确认人
     */
    public void setConfirmer(Long confirmer) {
        this.confirmer = confirmer;
    }
    /**
     * 确认人名称
     */
    public String getConfirmerName() {
        return confirmerName;
    }

    /**
     * 确认人名称
     */
    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }
    /**
     * 出售方类型 0=项目，1=公司
     */
    public Integer getBelongType() {
        return belongType;
    }

    /**
     * 出售方类型 0=项目，1=公司
     */
    public void setBelongType(Integer belongType) {
        this.belongType = belongType;
    }
    /**
     * 资产发布人
     */
    public Long getSeller() {
        return seller;
    }

    /**
     * 资产发布人
     */
    public void setSeller(Long seller) {
        this.seller = seller;
    }
    /**
     * 资产发布人名称
     */
    public String getSellerName() {
        return sellerName;
    }

    /**
     * 资产发布人名称
     */
    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    /**
     * 出售方组织主键
     */
    public Long getSellOrg() {
        return sellOrg;
    }

    /**
     * 出售方组织主键
     */
    public void setSellOrg(Long sellOrg) {
        this.sellOrg = sellOrg;
    }
    /**
     * 出售方组织名称
     */
    public String getSellOrgName() {
        return sellOrgName;
    }

    /**
     * 出售方组织名称
     */
    public void setSellOrgName(String sellOrgName) {
        this.sellOrgName = sellOrgName;
    }
    /**
     * 出售方项目
     */
    public Long getSellProject() {
        return sellProject;
    }

    /**
     * 出售方项目
     */
    public void setSellProject(Long sellProject) {
        this.sellProject = sellProject;
    }
    /**
     * 出售方项目名称
     */
    public String getSellProjectName() {
        return sellProjectName;
    }

    /**
     * 出售方项目名称
     */
    public void setSellProjectName(String sellProjectName) {
        this.sellProjectName = sellProjectName;
    }
    /**
     * 出售方地址主键
     */
    public Long getSellAddressId() {
        return sellAddressId;
    }

    /**
     * 出售方地址主键
     */
    public void setSellAddressId(Long sellAddressId) {
        this.sellAddressId = sellAddressId;
    }
    /**
     * 出售方详细地址
     */
    public String getSellAddress() {
        return sellAddress;
    }

    /**
     * 出售方详细地址
     */
    public void setSellAddress(String sellAddress) {
        this.sellAddress = sellAddress;
    }
    /**
     * 出售方联系人
     */
    public String getSellUserName() {
        return sellUserName;
    }

    /**
     * 出售方联系人
     */
    public void setSellUserName(String sellUserName) {
        this.sellUserName = sellUserName;
    }
    /**
     * 出售方联系电话
     */
    public String getSellPhone() {
        return sellPhone;
    }

    /**
     * 出售方联系电话
     */
    public void setSellPhone(String sellPhone) {
        this.sellPhone = sellPhone;
    }
    /**
     * 购买方联系人
     */
    public String getBuyer() {
        return buyer;
    }

    /**
     * 购买方联系人
     */
    public void setBuyer(String buyer) {
        this.buyer = buyer;
    }
    /**
     * 购买方组织主键
     */
    public Long getBuyOrg() {
        return buyOrg;
    }

    /**
     * 购买方组织主键
     */
    public void setBuyOrg(Long buyOrg) {
        this.buyOrg = buyOrg;
    }
    /**
     * 购买方组织名称
     */
    public String getBuyOrgName() {
        return buyOrgName;
    }

    /**
     * 购买方组织名称
     */
    public void setBuyOrgName(String buyOrgName) {
        this.buyOrgName = buyOrgName;
    }
    /**
     * 购买方项目主键
     */
    public Long getBuyProject() {
        return buyProject;
    }

    /**
     * 购买方项目主键
     */
    public void setBuyProject(Long buyProject) {
        this.buyProject = buyProject;
    }
    /**
     * 购买方项目名称
     */
    public String getBuyProjectName() {
        return buyProjectName;
    }

    /**
     * 购买方项目名称
     */
    public void setBuyProjectName(String buyProjectName) {
        this.buyProjectName = buyProjectName;
    }
    /**
     * 购买方地址主键
     */
    public Long getBuyAddressId() {
        return buyAddressId;
    }

    /**
     * 购买方地址主键
     */
    public void setBuyAddressId(Long buyAddressId) {
        this.buyAddressId = buyAddressId;
    }
    /**
     * 购买方详细地址
     */
    public String getBuyAddress() {
        return buyAddress;
    }

    /**
     * 购买方详细地址
     */
    public void setBuyAddress(String buyAddress) {
        this.buyAddress = buyAddress;
    }
    /**
     * 购买方电话
     */
    public String getBuyPhone() {
        return buyPhone;
    }

    /**
     * 购买方电话
     */
    public void setBuyPhone(String buyPhone) {
        this.buyPhone = buyPhone;
    }
    /**
     * 0-是  1-否
     */
    public String getIsPack() {
        return isPack;
    }

    /**
     * 0-是  1-否
     */
    public void setIsPack(String isPack) {
        this.isPack = isPack;
    }
    /**
     * 取消人
     */
    public String getCancel() {
        return cancel;
    }

    /**
     * 取消人
     */
    public void setCancel(String cancel) {
        this.cancel = cancel;
    }
    /**
     * 
     */
    public String getCancelName() {
        return cancelName;
    }

    /**
     * 
     */
    public void setCancelName(String cancelName) {
        this.cancelName = cancelName;
    }
    /**
     * 取消时间
     */
    public java.util.Date getCancelTime() {
        return cancelTime;
    }

    /**
     * 取消时间
     */
    public void setCancelTime(java.util.Date cancelTime) {
        this.cancelTime = cancelTime;
    }
    /**
     * 取消类型，0=买家，1=卖家，2-超时,3-审批驳回取消
     */
    public Integer getCancelType() {
        return cancelType;
    }

    /**
     * 取消类型，0=买家，1=卖家，2-超时,3-审批驳回取消
     */
    public void setCancelType(Integer cancelType) {
        this.cancelType = cancelType;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 确认人名称
     */
    public String getConfirmName() {
        return confirmName;
    }

    /**
     * 确认人名称
     */
    public void setConfirmName(String confirmName) {
        this.confirmName = confirmName;
    }
    /**
     * 资产类型
     */
    public String getShelfType() {
        return shelfType;
    }

    /**
     * 资产类型
     */
    public void setShelfType(String shelfType) {
        this.shelfType = shelfType;
    }
    /**
     * 上架时间
     */
    public java.util.Date getShelfTime() {
        return shelfTime;
    }

    /**
     * 上架时间
     */
    public void setShelfTime(java.util.Date shelfTime) {
        this.shelfTime = shelfTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
