/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="order")
public class OrderBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOrderService service;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity entry = (OrderEntity)((Object)this.service.getById(billId));
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("weChat");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(entry.getSellerName() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7269\u8d44\u90e8\u5ba1\u6279\u4eba:>----------" + sender + this.baseHost);
        String formurl = this.baseHost + "cr12g-panhuo-frontend/#/approvePages/order?id=" + entry.getId();
        String mobileUrl = this.baseHost + "cr12g-panhuo-mobile/#/approvePages/order?id=" + entry.getId();
        String subject = "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6d41\u7a0b\u9700\u8981\u60a8\u5ba1\u6279";
        String content = "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6d41\u7a0b\u3010" + entry.getSellProjectName() + "+" + entry.getBillCode() + "\u3011\u9700\u8981\u60a8\u5ba1\u6279\uff0c<a href=" + '\"' + formurl + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>";
        this.service.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("111111111111111111" + state);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8ba2\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.UNAPPROVED.getBillStateCode() == state) {
            OrderEntity entity = (OrderEntity)((Object)this.service.getById(billId));
            GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
            if (BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums()) >= 0) {
                LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
                lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                lambdachange.eq(OrderEntity::getGoodsId, (Object)entity.getGoodsId());
                lambdachange.eq(OrderEntity::getType, (Object)0);
                lambdachange.ne(BaseEntity::getId, (Object)entity.getId());
                List list = this.service.list((Wrapper)lambdachange);
                if (null == list || list.size() <= 0) {
                    goodsEntity.setStatus(1);
                    goodsEntity.setLowerType(1);
                    goodsEntity.setLower(InvocationInfoProxy.getUserid());
                    goodsEntity.setLowerTime(DateFormater.getCurrentDate());
                } else {
                    BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
                    BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                    goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
                    goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
                }
            } else {
                BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
                BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
                goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
            }
            this.goodsService.saveOrUpdate((Object)goodsEntity, false);
            entity.setType(2);
            entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
            entity.setCancelName(this.sessionManager.getUserContext().getUserName());
            entity.setCancelType(3);
            entity.setCancelTime(DateFormater.getCurrentDate());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }
}

