/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.CheckDetailEntity;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.bean.PlanDetailEntity;
import com.ejianc.business.asset.bean.PlanEntity;
import com.ejianc.business.asset.service.ICheckService;
import com.ejianc.business.asset.service.IPlanService;
import com.ejianc.business.asset.vo.CheckDetailVO;
import com.ejianc.business.asset.vo.CheckVO;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"check"})
public class CheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService service;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAllotService allotService;
    @Autowired
    private IPlanService planService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/copyCheckFile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> copyCheckFile(Long goodsId) {
        return this.service.copyCheckFile(goodsId);
    }

    @RequestMapping(value={"/queryPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryPlan(Long id) {
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(id));
        CheckVO vo = new CheckVO();
        vo.setCheckDate(new Date());
        vo.setOrgId(planEntity.getOrgId());
        vo.setOrgName(planEntity.getOrgName());
        vo.setPlanId(id);
        vo.setBelongType(Integer.valueOf(0));
        vo.setCheckType(Integer.valueOf(0));
        vo.setProjectId(planEntity.getProjectId());
        vo.setProjectName(planEntity.getProjectName());
        vo.setEngineeringType(planEntity.getEngineeringType());
        vo.setEngineeringTypeName(planEntity.getEngineeringTypeName());
        vo.setParentOrgId(planEntity.getParentOrgId());
        vo.setParentOrgName(planEntity.getParentOrgName());
        ArrayList<CheckDetailVO> list = new ArrayList<CheckDetailVO>();
        List<PlanDetailEntity> planDetail = planEntity.getPlanDetail();
        if (CollectionUtils.isNotEmpty(planDetail)) {
            for (PlanDetailEntity p : planDetail) {
                CheckDetailVO v = new CheckDetailVO();
                v.setId(p.getId());
                v.setAssetType(p.getAssetType());
                v.setAssetCode(null);
                v.setAssetId(null);
                v.setMaterialTypeId(p.getMaterialTypeId());
                v.setMaterialTypeCode(p.getMaterialTypeCode());
                v.setMaterialTypeName(p.getMaterialTypeName());
                v.setMaterialId(p.getMaterialId());
                v.setMaterialCode(p.getMaterialCode());
                v.setMaterialName(p.getMaterialName());
                v.setUnit(p.getUnit());
                v.setSpec(p.getSpec());
                v.setPlanNum(p.getNums());
                v.setSumNum(p.getSumNums());
                v.setAssetBelongType(Integer.valueOf(0));
                v.setCheckNum(p.getAssetType() == 0 ? null : BigDecimal.ONE);
                v.setRowState("add");
                BigDecimal sumNums = p.getSumNums() == null ? BigDecimal.ZERO : p.getSumNums();
                if (sumNums.compareTo(p.getNums()) >= 0) continue;
                list.add(v);
            }
            vo.setCheckDetail(list);
        }
        CommonResponse<CheckVO> checkVOCommonResponse = this.service.copyPlanFile(id, vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        List idlist = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : idlist) {
            CheckEntity entity = (CheckEntity)((Object)this.service.selectById(id));
            if (null != entity.getAllotId() && 0L != entity.getAllotId()) {
                AllotEntity allotEntity = (AllotEntity)((Object)this.allotService.selectById(entity.getAllotId()));
                allotEntity.setState(0);
                this.allotService.updateById((Object)allotEntity);
            }
            if (null == entity.getPlanId()) continue;
            PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(entity.getPlanId()));
            List<CheckDetailEntity> detail = entity.getCheckDetail();
            List<PlanDetailEntity> planDetail = planEntity.getPlanDetail();
            if (!CollectionUtils.isNotEmpty(detail) || !CollectionUtils.isNotEmpty(planDetail)) continue;
            Map<Long, CheckDetailEntity> numMap = detail.stream().collect(Collectors.toMap(CheckDetailEntity::getMaterialId, account -> account));
            for (PlanDetailEntity p : planDetail) {
                Long materialId = p.getMaterialId();
                CheckDetailEntity dec = numMap.get(materialId);
                if (dec == null) continue;
                p.setSumNums(p.getSumNums().subtract(dec.getCheckNum()));
            }
            planEntity.setCheckState(0);
            this.planService.saveOrUpdate((Object)planEntity, false);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        param.getParams().put("belongType", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryOrgList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryOrgList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        param.getParams().put("belongType", new Parameter("eq", (Object)1));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("belongType", new Parameter("eq", (Object)0));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage pageData = this.service.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), CheckVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getCheckType() == 0) {
                    vo.setCheckTypeName("\u9879\u76ee\u81ea\u91c7");
                } else {
                    vo.setCheckTypeName("\u5185\u90e8\u8c03\u62e8");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelOrgExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelOrgExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("signerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("belongType", new Parameter("eq", (Object)1));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage pageData = this.service.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), CheckVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getCheckType() == 0) {
                    vo.setCheckTypeName("\u9879\u76ee\u81ea\u91c7");
                } else {
                    vo.setCheckTypeName("\u5185\u90e8\u8c03\u62e8");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("checkOrgExport.xlsx", beans, response);
    }
}

