/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AddressEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IAddressService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"order"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrderService service;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAddressService addressService;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weChat.cgdd-agentid}")
    private String cgddAgentid;
    @Value(value="${weChat.cgdd-secret}")
    private String cgddSecret;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.saveOrder(saveorUpdateVO));
    }

    @RequestMapping(value={"/confirmerOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> confirmerOrder(@RequestBody OrderVO saveorUpdateVO) {
        this.service.confirmerOrder(saveorUpdateVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(id));
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(orderEntity.getGoodsId()));
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        vo.setRemainingNums(goodsEntity.getRemainingNums());
        vo.setRotatableNums(goodsEntity.getRotatableNums());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryShelfDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryShelfDetail(Long id) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(id));
        GoodsEntity entity = (GoodsEntity)((Object)this.goodsService.selectById(orderEntity.getGoodsId()));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("status", new Parameter("eq", (Object)0));
        List listGoods = this.goodsService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods) && listGoods.size() > 0) {
            throw new BusinessException("\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u4e0a\u67b6\uff0c\u4e0d\u53ef\u91cd\u590d\u4e0a\u67b6");
        }
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam2.getParams().put("status", new Parameter("eq", (Object)1));
        queryParam2.getParams().put("lowerType", new Parameter("eq", (Object)1));
        List listGoods2 = this.goodsService.queryList(queryParam2, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods2) && listGoods2.size() > 0) {
            throw new BusinessException("\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u5b8c\u6210\uff0c\u4e0d\u53ef\u5468\u8f6c");
        }
        vo.setId(Long.valueOf(IdWorker.getId()));
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setPrice(null);
        vo.setDiscount(null);
        vo.setOriginalprice(orderEntity.getPrice());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRemainingNums(entity.getNums());
        vo.setRotatableNums(entity.getNums());
        vo.setType(1);
        vo.setOrderId(id);
        AddressEntity addressEntity = (AddressEntity)((Object)this.addressService.getById(orderEntity.getBuyAddressId()));
        vo.setAddressId(addressEntity.getId());
        vo.setAddress(addressEntity.getAddress());
        vo.setAddressName(addressEntity.getProjectName());
        vo.setProjectAddress(addressEntity.getProjectAddress());
        vo.setPhone(addressEntity.getPhone());
        vo.setName(addressEntity.getName());
        vo.setLat(addressEntity.getLat());
        vo.setLon(addressEntity.getLon());
        vo.setFirstLocation(addressEntity.getFirstLocation());
        vo.setSecondLocation(addressEntity.getSecondLocation());
        vo.setThirdLocation(addressEntity.getThirdLocation());
        vo.setFourthLocation(addressEntity.getFourthLocation());
        vo.setLocation(addressEntity.getLocation());
        vo.setProjectId(addressEntity.getProjectId());
        vo.setProjectName(addressEntity.getProjectName());
        vo.setOrgId(addressEntity.getOrgId());
        vo.setOrgName(addressEntity.getOrgName());
        CommonResponse response = this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT200813000000001", "imgUpload", vo.getId().toString(), "BT200813000000001", "imgUpload");
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkTurnover"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkTurnover(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("status", new Parameter("eq", (Object)0));
        List listGoods = this.goodsService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods) && listGoods.size() > 0) {
            return CommonResponse.error((int)5001, (String)"\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u4e0a\u67b6\uff0c\u4e0d\u53ef\u91cd\u590d\u4e0a\u67b6\uff01");
        }
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam2.getParams().put("status", new Parameter("eq", (Object)1));
        queryParam2.getParams().put("lowerType", new Parameter("eq", (Object)1));
        List listGoods2 = this.goodsService.queryList(queryParam2, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods2) && listGoods2.size() > 0) {
            return CommonResponse.error((int)5001, (String)"\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u5b8c\u6210\uff0c\u4e0d\u53ef\u5468\u8f6c\uff01");
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellOrgName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)0));
        if (null != isMyOrder && isMyOrder.getValue() != null) {
            if ("0".equals(isMyOrder.getValue())) {
                param.getParams().put("orderUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if ("1".equals(isMyOrder.getValue())) {
                param.getParams().put("orderUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            } else {
                param.getParams().remove("isMyOrder");
            }
        }
        param.getParams().remove("isMyOrder");
        this.setOrgParam("buyOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            param.getParams().put(key, new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter("in", childIds));
            }
        }
    }

    @RequestMapping(value={"/queryMyOrderEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)2));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue() != null) {
            if ("0".equals(isMyOrder.getValue())) {
                param.getParams().put("orderUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if ("1".equals(isMyOrder.getValue())) {
                param.getParams().put("orderUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            } else {
                param.getParams().remove("isMyOrder");
            }
        }
        param.getParams().remove("isMyOrder");
        this.setOrgParam("buyOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderFinish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderFinish(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue() != null) {
            if ("0".equals(isMyOrder.getValue())) {
                param.getParams().put("orderUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            } else if ("1".equals(isMyOrder.getValue())) {
                param.getParams().put("orderUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            } else {
                param.getParams().remove("isMyOrder");
            }
        }
        param.getParams().remove("isMyOrder");
        this.setOrgParam("buyOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)0));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        param.getParams().remove("isMyGoods");
        this.setOrgParam("sellOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)2));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        param.getParams().remove("isMyGoods");
        this.setOrgParam("sellOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellFinish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellFinish(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        Parameter isMyGoods = (Parameter)param.getParams().get("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        param.getParams().remove("isMyGoods");
        this.setOrgParam("sellOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateBuyStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
        if (entity.getVersion() != saveorUpdateVO.getVersion()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        if (BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums()) >= 0) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId, (Object)entity.getGoodsId());
            lambdachange.eq(OrderEntity::getType, (Object)0);
            lambdachange.ne(BaseEntity::getId, (Object)entity.getId());
            List list = this.service.list((Wrapper)lambdachange);
            if (null == list || list.size() <= 0) {
                goodsEntity.setStatus(1);
                goodsEntity.setLowerType(1);
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            } else {
                BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
                BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
                goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
            }
        } else {
            BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
            BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
            goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
            goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("weChat");
        ArrayList<String> sellerName = new ArrayList<String>();
        sellerName.add(entity.getSellerName() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sellerName);
        String formurl = this.baseHost + "cr12g-panhuo-frontend/#/buyOrder/card?id=" + entity.getId();
        String mobileUrl = this.baseHost + "cr12g-panhuo-mobile/#/buyOrder/card?id=" + entity.getId();
        String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u4e70\u5bb6\u53d6\u6d88";
        String content = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u4e70\u5bb6\u53d6\u6d88\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.service.sendMsg(messageType, sellerName, "notice", subject, content, mobileUrl);
        entity.setType(2);
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(this.sessionManager.getUserContext().getUserName());
        entity.setCancelType(0);
        entity.setCancelTime(DateFormater.getCurrentDate());
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateSellStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateSellStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        if (entity.getVersion() != saveorUpdateVO.getVersion()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        if (entity.getBillState() != BillStateEnum.COMMITED_STATE.getBillStateCode() && entity.getBillState() != BillStateEnum.PASSED_STATE.getBillStateCode()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
        if (BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums()) >= 0) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId, (Object)entity.getGoodsId());
            lambdachange.eq(OrderEntity::getType, (Object)0);
            lambdachange.ne(BaseEntity::getId, (Object)entity.getId());
            List list = this.service.list((Wrapper)lambdachange);
            if (null == list || list.size() <= 0) {
                goodsEntity.setStatus(1);
                goodsEntity.setLowerType(1);
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            } else {
                BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
                BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
                goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
            }
        } else {
            BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
            BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
            goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
            goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("weChat");
        ArrayList<String> orderUserName = new ArrayList<String>();
        orderUserName.add(entity.getOrderUserName() + "");
        this.logger.info("\u53d1\u9001\u6d88\u606f\u7ed9\u9884\u5b9a\u4eba:>----------" + orderUserName);
        String formurl = this.baseHost + "cr12g-panhuo-frontend/#/buyOrder/card?id=" + entity.getId();
        String mobileUrl = this.baseHost + "cr12g-panhuo-mobile/#/buyOrder/card?id=" + entity.getId();
        String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u5356\u5bb6\u53d6\u6d88";
        String content = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u5356\u5bb6\u53d6\u6d88\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.service.sendMsg(messageType, orderUserName, "notice", subject, content, mobileUrl);
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        entity.setType(2);
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(this.sessionManager.getUserContext().getUserName());
        entity.setCancelType(1);
        entity.setCancelTime(DateFormater.getCurrentDate());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/closeOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse closeOrder(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        int hour = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + hour + "----");
        if (hour > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, calendar.get(11) - hour);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.le(OrderEntity::getBuyTime, (Object)df.format(calendar.getTime()));
            lambdachange.eq(OrderEntity::getType, (Object)0);
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.info("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                HashMap map = new HashMap();
                list.forEach(entity -> {
                    entity.setType(2);
                    entity.setCancel("99999");
                    entity.setCancelName("\u5230\u671f\u81ea\u52a8\u53d6\u6d88");
                    entity.setCancelType(2);
                    entity.setCancelTime(DateFormater.getCurrentDate());
                    GoodsEntity goodsEntity = (GoodsEntity)((Object)((Object)this.goodsService.selectById(entity.getGoodsId())));
                    BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
                    BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                    goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
                    goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
                    this.goodsService.updateById((Object)goodsEntity);
                    ArrayList<String> messageType = new ArrayList<String>();
                    messageType.add("sys");
                    messageType.add("weChat");
                    ArrayList<String> sender = new ArrayList<String>();
                    sender.add(entity.getSeller() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender);
                    String formurl = this.baseHost + "ejc-panhuo-frontend/#/sellOrder/details?id=" + entity.getId() + "&type=3";
                    String mobileUrl = this.baseHost + "ejc-panhuo-mobile/#/sellerManage/card?id=" + entity.getId() + "&userid={userid}";
                    String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5230\u671f\u672a\u786e\u8ba4\uff0c\u5df2\u5931\u6548";
                    String content = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5230\u671f\u672a\u786e\u8ba4\uff0c\u5df2\u5931\u6548\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                    ArrayList<String> messageType2 = new ArrayList<String>();
                    messageType2.add("sys");
                    messageType.add("weChat");
                    ArrayList<String> sender2 = new ArrayList<String>();
                    sender2.add(entity.getOrderUserId() + "");
                    this.logger.info("\u9884\u8ba2\u4eba:>----------" + sender2);
                    String formurl2 = "https://dev.17elian.com/ejc-panhuo-frontend/#/assetMarket/orderMarket?id=" + entity.getId();
                    String mobileUrl2 = this.baseHost + "ejc-panhuo-mobile/#/buyOrder/card?id=" + entity.getId() + "&userid={userid}";
                    String subject2 = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5356\u5bb6\u672a\u53ca\u65f6\u786e\u8ba4\u5df2\u53d6\u6d88";
                    String content2 = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5356\u5bb6\u672a\u53ca\u65f6\u786e\u8ba4\u5df2\u53d6\u6d88\u3002<a href=" + '\"' + formurl2 + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType2, sender2, "notice", subject2, content2, mobileUrl2);
                });
                this.service.updateBatchById(list);
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String url) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.cgddAgentid);
            weixineeParams.put("secret", (Object)this.cgddSecret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("url", (Object)url);
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

