package com.ejianc.business.panhuo.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 资产表
 * 
 * @author generator
 * 
 */
@Mapper
public interface GoodsMapper extends BaseCrudMapper<GoodsEntity> {

    List<GoodsEntity> getGoods(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper,@Param("lon") String lon,@Param("lat")String lat);

    ReportVO getPronums(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    ReportVO getGoodsnums(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    ReportVO getGoodsnumsIng(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    ReportVO getOrdernums(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    List<ReportVO> getPeriodStatistics(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    List<ReportVO> getProportion(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    List<ReportVO> getGoodsProportion(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    List<ReportVO> getGoodsIngProportion(@Param("tenantId") Long tenantId,@Param("orgIds") List<Long> orgIds);

    @Select("<script>"+
            "SELECT material_name,SUM(rotatable_nums) AS rotatable_nums,price,id FROM  ejc_panhuo_goods WHERE dr =0" +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>" +
            "AND material_name =#{materialName}"+
            "GROUP BY material_name"+
            "</script>")
    List<GoodsVO> selectDetail(@Param("projectId") Long projectId, @Param("orgId") Long orgId, @Param("materialName") String materialName);
    @Select("<script>"+
            "SELECT material_name,SUM(remaining_nums) AS remaining_nums,price FROM  ejc_panhuo_goods WHERE dr =0" +
            "<if test = 'null != projectId and \"\" != projectId' >" +
            "AND project_id = #{projectId} " +
            "</if>" +
            "<if test = 'null != orgId and \"\" != orgId' >" +
            "AND org_id = #{orgId} " +
            "</if>" +
            "AND material_name =#{materialName}"+
            "AND status = 4 " +
            "GROUP BY material_name"+
            "</script>")
    List<GoodsVO> selectRecover(Long projectId, Long orgId, String materialName);
}
