package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hystrix.TtplanHystrix;
import com.ejianc.business.dataexchange.vo.Ttplan;
import com.ejianc.business.dataexchange.vo.TtplanB;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * NC周材总控计划接口
 *
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = TtplanHystrix.class)
public interface ITtplanApi {



	/**
	 * NC总控表头同步查询
	 * @return
	 */
	@GetMapping(value = "/api/ttplan/list")
	public CommonResponse<List<Ttplan>> queryNCTtPlanlByTs(@RequestParam(required = true) String ts);


	/**
	 * NC总控表体同步查询
	 * @return
	 */
	@GetMapping(value = "/api/ttplan/detailList")
	public CommonResponse<List<TtplanB>> queryNCTtPlanDetailByTs(@RequestParam(required = true) String ts);



}
