package com.ejianc.business.dataexchange.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dataexchange.hystrix.RdclHystrix;
import com.ejianc.business.dataexchange.vo.Rdcl;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 收发类别参照接口
 * 
 * @author brin
 *
 */
@FeignClient(name= "cscec5b-dataexchange-web", url="${common.env.feign-client-url}", path="cscec5b-dataexchange-web", fallback = RdclHystrix.class)
public interface IRdclApi {

	/**
	 * 库存组织参照查询
	 * @return
	 */
	@GetMapping(value = "/api/queryRdclRef")
	public CommonResponse<IPage<Rdcl>> queryCalBodyRef(
												@RequestParam(defaultValue = "1") Integer pageNumber,
												@RequestParam(defaultValue = "10") Integer pageSize,
												@RequestParam(value = "condition", required = false) String condition,
												@RequestParam(value = "searchText", required = false) String searchText);

}
