package com.ejianc.business.dataexchange.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.api.IPurorgApi;
import com.ejianc.business.dataexchange.service.IPurorgService;
import com.ejianc.business.dataexchange.service.IRdclService;
import com.ejianc.business.dataexchange.vo.Purorg;
import com.ejianc.business.dataexchange.vo.Rdcl;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


@RestController
@RequestMapping("/api/")
public class PurorgApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurorgService purorgService;


    @RequestMapping(value = "queryPurorgRef", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<Purorg>> queryPurorgRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("purorgcode");
        fuzzyFields.add("purorgname");

        /** 租户隔离 */
        Long supplierId = null;
        if(org.apache.commons.lang3.StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                logger.info("参数supplierId--"+supplierId);
            }
        }

        //queryParam.getOrderMap().put("checkDate", QueryParam.DESC);
        //IPage<Stordoc> page = calBodyService.queryPage(queryParam,false);
        Page<Purorg> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<Purorg> listres = purorgService.queryPurorgs(page,wrapper,supplierId);
        IPage<Purorg> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
