package com.ejianc.business.dataexchange.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.service.ICorpService;
import com.ejianc.business.dataexchange.vo.Corp;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


@RestController
@RequestMapping("corp")
public class CorpController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICorpService corpService;


    @RequestMapping(value = "queryNCCorpRef", method= RequestMethod.GET)
    @ResponseBody
    public List<Corp> queryNCCorpRef(
            @RequestParam(required = false) String pid,
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        //InvocationInfoProxy.getUserid();
        List<Corp> datalist = null;

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
//        queryParam.setPageIndex(pageNumber);
//        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("unitcode");
        fuzzyFields.add("unitname");

        if("@@@@".equals(pid)) {
            pid = null;
        }

        /** 租户隔离 */
        Long supplierId = null;
        if(org.apache.commons.lang3.StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                logger.info("参数supplierId--"+supplierId);
            }
        }


        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<Corp> listres = corpService.queryNCCoprList(wrapper,pid);
        for (Corp c : listres
             ) {
            if(c.getFathercorp() == null)
                c.setFathercorp("@");
        }
        return buildTree(listres);
    }

    //构建公司树
    public List<Corp> buildTree(List<Corp> pidList){
        Map<String,List<Corp>> pidListMap =
                pidList.stream().collect(Collectors.groupingBy(Corp::getFathercorp));
        pidList.stream().forEach(item->item.setChildren(pidListMap.get(item.getPkcorp())));
      //  System.out.println(JSON.toJSONString(pidListMap.get("@")));
        //返回顶层节点的list
        return pidListMap.get("@");
    }
}
