package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.ICubasService;
import com.ejianc.business.dataexchange.service.IProjectService;
import com.ejianc.business.dataexchange.vo.Cubas;
import com.ejianc.business.dataexchange.vo.Project;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping("/api/")
public class CustApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICubasService cubasService;


    /**
     * NC供应商同步查询
     * @return
     */
    @GetMapping(value = "/cust/list")
    public CommonResponse<List<Cubas>> queryUsersByTs(@RequestParam(required = true) String ts,
                                                      @RequestParam(value = "pkCorp", required = false) String pkCorp) {
        List<Cubas> custs = cubasService.selectListAll(ts,pkCorp);
        return CommonResponse.success("查询供应商同步数据成功！",custs);
    }

}
