package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.IProjectService;
import com.ejianc.business.dataexchange.vo.Project;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping("/api/")
public class ProjectApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectService projectService;


    /**
     * NC项目同步查询
     * @return
     */
    @GetMapping(value = "/project/list")
    public CommonResponse<List<Project>> queryUsersByTs(@RequestParam(required = true) String ts,
                                                        @RequestParam(value = "pkCorp", required = false) String pkCorp) {
        List<Project> projects = projectService.queryNCProjectsByTs(ts,pkCorp);

        return CommonResponse.success("查询项目同步数据成功！",projects);
    }

}
