package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.IAreaclService;
import com.ejianc.business.dataexchange.service.ICubasService;
import com.ejianc.business.dataexchange.service.IProjectService;
import com.ejianc.business.dataexchange.vo.Areacl;
import com.ejianc.business.dataexchange.vo.Cubas;
import com.ejianc.business.dataexchange.vo.Project;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping("/api/")
public class CustApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICubasService cubasService;

    @Autowired
    private IAreaclService areaclService;


    /**
     * NC供应商同步查询
     * @return
     */
    @GetMapping(value = "/cust/list")
    public CommonResponse<List<Cubas>> queryUsersByTs(@RequestParam(required = true) String ts,
                                                      @RequestParam(value = "pkCorp", required = false) String pkCorp) {
        List<Cubas> custs = cubasService.selectListAll(ts,pkCorp);
        return CommonResponse.success("查询供应商同步数据成功！",custs);
    }

    /**
     * NC供应商同步查询（区间）
     * @return
     */
    @GetMapping(value = "/cust/listByQj")
    public CommonResponse<List<Cubas>> queryCustByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime,
                                                     @RequestParam(required = false) Integer beginRow, @RequestParam(required = false) Integer endRow,
                                                      @RequestParam(value = "pkCorp", required = false) String pkCorp) {
        List<Cubas> custs = cubasService.selectListAllByQj(beginTime,endTime, beginRow, beginRow, pkCorp);
        return CommonResponse.success("查询供应商同步数据成功！",custs);
    }

    /**
     * NC地区分类同步查询
     * @return
     */
    @GetMapping(value = "/areacl/list")
    public CommonResponse<List<Areacl>> queryAreaclByTs(@RequestParam(required = true) String ts ) {
        List<Areacl> areacls = areaclService.selectListAll(ts);
        return CommonResponse.success("查询地区档案同步数据成功！",areacls);
    }

}
