package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.IInvbasService;
import com.ejianc.business.dataexchange.service.IInvclService;
import com.ejianc.business.dataexchange.service.IInvmanService;
import com.ejianc.business.dataexchange.vo.Invbas;
import com.ejianc.business.dataexchange.vo.Invcl;
import com.ejianc.business.dataexchange.vo.Invman;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController
@RequestMapping("/api/")
public class InvApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInvclService invclService;

    @Autowired
    private IInvbasService invbasService;

    @Autowired
    private IInvmanService invmanService;


    /**
     * NC物料分类同步查询
     * @return
     */
    @GetMapping(value = "/invcl/list")
    public CommonResponse<List<Invcl>> queryNCInvclByTs(@RequestParam(required = true) String ts) {
        List<Invcl> invcls = invclService.queryNCInvclsByTs(ts);
        return CommonResponse.success("查询物料分类同步数据成功！",invcls);
    }

    /**
     * NC物料基本档案同步查询
     * @return
     */
    @GetMapping(value = "/invbas/list")
    public CommonResponse<List<Invbas>> queryNCInvbasByTs(@RequestParam(required = true) String ts) {
        List<Invbas> invbass = invbasService.queryNCInvbassByTs(ts);
        return CommonResponse.success("查询物料基本档案同步数据成功！",invbass);
    }

    /**
     * NC物料基本档案同步查询(区间)
     * @return
     */
    @GetMapping(value = "/invbas/listByQj")
    public CommonResponse<List<Invbas>> queryNCInvbasByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime,
                                                          @RequestParam(required = false) Integer beginRow, @RequestParam(required = false) Integer endRow) {
        List<Invbas> invbass = invbasService.queryNCInvbassByQj(beginTime, endTime, beginRow, endRow);
        return CommonResponse.success("查询物料基本档案同步数据成功！",invbass);
    }


    /**
     * NC物料管理档案同步查询
     * @return
     */
    @GetMapping(value = "/invman/list")
    public CommonResponse<List<Invman>> queryNCInvmanByTs(@RequestParam(required = true) String ts,@RequestParam(required = false) String pkCorp) {
        List<Invman> invmans = invmanService.selectListAll(ts,pkCorp);
        return CommonResponse.success("查询物料管理档案同步数据成功！",invmans);
    }

    /**
     * NC物料管理档案同步查询(区间)
     * @return
     */
    @GetMapping(value = "/invman/listByQj")
    public CommonResponse<List<Invman>> queryNCInvmanByQj(@RequestParam(required = false) String beginTime, @RequestParam(required = false) String endTime, @RequestParam(required = false) Integer beginRow,
                                                          @RequestParam(required = false) Integer endRow,@RequestParam(required = false) String pkCorp) {
        List<Invman> invmans = invmanService.selectListAllByQj(beginTime, endTime, beginRow, endRow, pkCorp);
        return CommonResponse.success("查询物料管理档案同步数据成功！",invmans);
    }
}
