/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dataexchange.service.ICorpTreeService;
import com.ejianc.business.dataexchange.vo.CorpTreeVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"corptree"})
public class CorpTreeController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICorpTreeService corpTreeService;

    @RequestMapping(value={"queryNCCorpRef"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CorpTreeVO> queryNCCorpRef(@RequestParam(required=false) String pid, @RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        this.logger.info("\u7528\u7ec4\u7ec7\u6811\u53c2\u7167\u9a8c\u8bc1\u65e5\u5fd7\u6536\u96c6...");
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        if ("@@@@".equals(pid)) {
            pid = null;
        }
        Long supplierId = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("supplierId")) {
            supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
            this.logger.info("\u53c2\u6570supplierId--" + supplierId);
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<CorpTreeVO> listres = this.corpTreeService.queryNCCoprTreeList(wrapper, pid);
        for (CorpTreeVO c : listres) {
            if (c.getPid() != null) continue;
            c.setPid("@");
        }
        return this.buildTree(listres);
    }

    public List<CorpTreeVO> buildTree(List<CorpTreeVO> pidList) {
        Map<String, List<CorpTreeVO>> pidListMap = pidList.stream().collect(Collectors.groupingBy(CorpTreeVO::getPid));
        pidList.stream().forEach(item -> item.setChildren((List)pidListMap.get(item.getId())));
        return pidListMap.get("@");
    }
}

