package com.ejianc.business.dataexchange.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.service.ICmContractService;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;


@RestController
@RequestMapping("matcontract")
public class MatContractController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICmContractService cmContractService;


    @RequestMapping(value = "queryMatContractRef", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CmContract>> queryMatContractRef(
            @RequestParam(value = "pkCorp", required=false) String pkCorp,
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("contractname");
        fuzzyFields.add("contractcode");
        fuzzyFields.add("suppliername");
        /*if(StringUtils.isNotEmpty(pkCorp)){
            queryParam.getParams().put("pkCorp", new Parameter(QueryParam.EQ, pkCorp));
        }*/
        /** 租户隔离 */
        Long supplierId = null;
        String pkProject = null;
        String pkSupplier = null;
        String pkBilltype = "992C";
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                logger.info("参数supplierId--"+supplierId);
            }
            if(null != conditionMap.get("pkProject")) {
                pkProject = conditionMap.get("pkProject").toString();
                logger.info("pkProject--"+pkProject);
            }
            if(null != conditionMap.get("pkSupplier")) {
                pkSupplier = conditionMap.get("pkSupplier").toString();
                logger.info("pkSupplier--"+pkSupplier);
            }
            if(null != conditionMap.get("pkCorp")) {
                pkCorp =  conditionMap.get("pkCorp").toString();
                logger.info("参数pkCorp--"+pkCorp);
            }
            if(null != conditionMap.get("contractType") && 1 == Integer.parseInt((String) conditionMap.get("contractType"))) {
                pkBilltype = "992D";
            }
        }
        if(StringUtils.isNotEmpty(pkProject)){
            //queryParam.getParams().put("pk_project", new Parameter(QueryParam.EQ, pkProject));
            if(pkCorp == null || StringUtils.isEmpty(pkCorp)) {
                pkCorp = pkProject.substring(0,4);
            }

        }
        if(StringUtils.isNotEmpty(pkSupplier)){
            queryParam.getParams().put("pk_supplier", new Parameter(QueryParam.EQ, pkSupplier));
        }

        //  queryParam.getOrderMap().put("checkDate", QueryParam.DESC);
        //IPage<Stordoc> page = calBodyService.queryPage(queryParam,false);
        Page<CmContract> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        logger.info("参数pkCorp--controller---: {}",pkCorp);
        List<CmContract> listres = cmContractService.queryMatCmContract(page,wrapper,supplierId,pkCorp, pkBilltype,pkProject);
        IPage<CmContract> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
