package com.ejianc.business.dataexchange.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.service.ICmContractInfoService;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@RestController
@RequestMapping("contractinfo")
public class CmContractInfoController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICmContractInfoService cmContractInfoService;

    @Autowired
    private IMaterialApi materialApi;

    @RequestMapping(value = "queryCmContractInfoRef", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CmContractInfoVO>> querySubCmContractInfoRef(
            @RequestParam(value = "pkContract", required=false) String pkContract,
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("infocode");
        fuzzyFields.add("infoname");
        /*if(StringUtils.isNotEmpty(pkCorp)){
            queryParam.getParams().put("pkCorp", new Parameter(QueryParam.EQ, pkCorp));
        }*/
        /** 租户隔离 */
        Long supplierId = null;

        if(org.apache.commons.lang3.StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                logger.info("参数supplierId--"+supplierId);
            }
            if(null != conditionMap.get("pkContract")) {
                pkContract =  conditionMap.get("pkContract").toString();
                logger.info("参数pkContract--"+pkContract);
            }

        }

        Page<CmContractInfoVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<CmContractInfoVO> listres = cmContractInfoService.querySubContractInfos(page,wrapper,supplierId,pkContract);
        IPage<CmContractInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "queryMatContractInfoRef", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CmContractInfoVO>> queryMatContractInfoRef(
            @RequestParam(value = "pkContract", required=false) String pkContract,
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("infocode");
        fuzzyFields.add("infoname");
        /*if(StringUtils.isNotEmpty(pkCorp)){
            queryParam.getParams().put("pkCorp", new Parameter(QueryParam.EQ, pkCorp));
        }*/
        /** 租户隔离 */
        Long supplierId = null;
        String pkProject = null;

        if(org.apache.commons.lang3.StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                logger.info("参数supplierId--"+supplierId);
            }
            if(null != conditionMap.get("pkContract")) {
                pkContract =  conditionMap.get("pkContract").toString();
                logger.info("参数pkContract--"+pkContract);
            }
            if(null != conditionMap.get("pkProject")) {
                pkProject =  conditionMap.get("pkProject").toString();
                logger.info("参数pkProject--"+pkProject);
            }
        }
        if (pkProject == null) {
            throw new BusinessException("自建项目无法关联合同！");
        }

        Page<CmContractInfoVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<CmContractInfoVO> listres = cmContractInfoService.queryMatContractInfos(page,wrapper,supplierId,pkContract, pkProject);
        for (CmContractInfoVO cmContractInfoVO : listres) {
            CommonResponse<MaterialVO> matRes= materialApi.queryMaterialBySourceId(cmContractInfoVO.getPkInvbasdoc());
            if(matRes.isSuccess()) {
                MaterialVO materialVO = matRes.getData();
                cmContractInfoVO.setMaterialId(materialVO.getId());
                cmContractInfoVO.setMaterialTypeId(materialVO.getCategoryId());
                cmContractInfoVO.setMaterialTypeName(materialVO.getCategoryName());
            }
        }
        IPage<CmContractInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "queryLeaseContractInfoById", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CmContractInfoVO>> queryLeaseContractInfoById(String pkContract) {
        logger.info("传入参数合同主键 --pkContract---: {}", pkContract);
        List<CmContractInfoVO> entity = cmContractInfoService.queryLeaseContractInfoById(pkContract);
        for (CmContractInfoVO cmContractInfoVO : entity) {
            if (cmContractInfoVO.getPkInvbasdoc() != null) {
                CommonResponse<MaterialVO> matRes= materialApi.queryMaterialBySourceId(cmContractInfoVO.getPkInvbasdoc());
                if(matRes.isSuccess()) {
                    MaterialVO materialVO = matRes.getData();
                    cmContractInfoVO.setMaterialId(materialVO.getId());
                    cmContractInfoVO.setMaterialTypeId(materialVO.getCategoryId());
                    cmContractInfoVO.setMaterialTypeName(materialVO.getCategoryName());
                }
            } else if (cmContractInfoVO.getPkInvcl() != null) {
                CommonResponse<MaterialCategoryVO> matRes= materialApi.queryCategoryBySourceId(cmContractInfoVO.getPkInvcl());
                if(matRes.isSuccess()) {
                    MaterialCategoryVO materialCategoryVO = matRes.getData();
                    cmContractInfoVO.setMaterialTypeId(materialCategoryVO.getId());
                    cmContractInfoVO.setMaterialTypeName(materialCategoryVO.getName());
                }
            }
        }
        return CommonResponse.success("查询合同清单列表实体成功！", entity);
    }

    @RequestMapping(value = "queryMatContractInfoById", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CmContractInfoVO>> queryMatContractInfoById(String pkContract) {
        logger.info("传入物资参数合同主键 --pkContract---: {}", pkContract);
        List<CmContractInfoVO> entity = cmContractInfoService.queryMatContractInfoById(pkContract);
        return CommonResponse.success("查询合同清单列表实体成功！", entity);
    }
}
