/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.CorpDeptPathMapper;
import com.ejianc.business.dataexchange.service.ICorpDeptPathService;
import com.ejianc.business.dataexchange.service.ICorpTreeService;
import com.ejianc.business.dataexchange.vo.CorpDeptPath;
import com.ejianc.business.dataexchange.vo.CorpTreeVO;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="orpDeptPathService")
public class CorpDeptPathService
extends ServiceImpl<CorpDeptPathMapper, CorpDeptPath>
implements ICorpDeptPathService {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ICorpTreeService corpTreeService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String selectProjectFilePath(QueryWrapper queryWrapper, String deptcode, String deptname) {
        String path = null;
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6String\u7c7b\u578b\u7684path  ------------");
        if (deptcode != null && this.redisTemplate.opsForHash().hasKey((Object)"COPR-DEPT-PATH-N", (Object)deptcode).booleanValue()) {
            path = (String)this.redisTemplate.opsForHash().get((Object)"COPR-DEPT-PATH-N", (Object)deptcode);
            this.logger.info("------------  redisTemplate\u91cc\u6709key\u4e3adeptcode\u7684path ,path: ------------" + path);
            return path;
        }
        if (deptname != null && this.redisTemplate.opsForHash().hasKey((Object)"COPR-DEPT-PATH-N", (Object)deptname).booleanValue()) {
            path = (String)this.redisTemplate.opsForHash().get((Object)"COPR-DEPT-PATH-N", (Object)deptname);
            this.logger.info("------------  redisTemplate\u91cc\u6709key\u4e3adeptname\u7684path ,path: ------------" + path);
            return path;
        }
        List<CorpDeptPath> list = this.getCorpDeptList(queryWrapper);
        List ps = list.stream().filter(cdp -> cdp.getDeptcode() != null && deptcode != null && cdp.getDeptcode().equals(deptcode) || cdp.getDeptname() != null && deptname != null && cdp.getDeptname().equals(deptname)).collect(Collectors.toList());
        if (ps != null && !ps.isEmpty()) {
            CorpDeptPath cdp2 = (CorpDeptPath)ps.get(0);
            path = "/" + cdp2.getDeptname();
            String deptpath = this.findDeptPath(list, path, cdp2.getPkFathedept());
            String cpath = "/" + cdp2.getUnitname();
            List<CorpTreeVO> cts = this.getCorpList();
            String corppath = this.findCorpPath(cts, cpath, cdp2.getFathercorp());
            path = corppath + deptpath;
        }
        if (deptcode != null && path != null) {
            this.logger.info("------------  redisTemplate\u91cc\u8bbe\u7f6ekey\u4e3adeptcode\u7684path ,path: ------------" + path);
            this.redisTemplate.opsForHash().put((Object)"COPR-DEPT-PATH-N", (Object)deptcode, (Object)path);
        }
        if (deptname != null && path != null) {
            this.logger.info("------------  redisTemplate\u91cc\u8bbe\u7f6ekey\u4e3adeptname\u7684path ,path: ------------" + path);
            this.redisTemplate.opsForHash().put((Object)"COPR-DEPT-PATH-N", (Object)deptname, (Object)path);
        }
        return path;
    }

    private String findCorpPath(List<CorpTreeVO> list, String cpath, String fathercorp) {
        if (fathercorp == null) {
            return cpath;
        }
        List ps = list.stream().filter(cdp -> cdp.getId().equals(fathercorp)).collect(Collectors.toList());
        if (ps != null && !ps.isEmpty()) {
            CorpTreeVO cdp2 = (CorpTreeVO)ps.get(0);
            cpath = "/" + cdp2.getName() + cpath;
            this.logger.info("------------  \u83b7\u53d6\u5f00\u59cb\u83b7\u53d6corp\u8def\u5f84\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01cpath: " + cpath + "  ------------");
            return this.findCorpPath(list, cpath, cdp2.getPid());
        }
        return cpath;
    }

    private String findDeptPath(List<CorpDeptPath> list, String path, String pkFathedept) {
        if (pkFathedept == null) {
            return path;
        }
        List ps = list.stream().filter(cdp -> cdp.getPkDeptdoc().equals(pkFathedept)).collect(Collectors.toList());
        if (ps != null && !ps.isEmpty()) {
            CorpDeptPath cdp2 = (CorpDeptPath)ps.get(0);
            path = "/" + cdp2.getDeptname() + path;
            this.logger.info("------------  \u83b7\u53d6\u5f00\u59cb\u83b7\u53d6dept\u8def\u5f84\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01path: " + path + "  ------------");
            return this.findDeptPath(list, path, cdp2.getPkFathedept());
        }
        return path;
    }

    private List<CorpTreeVO> getCorpList() {
        List list = null;
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6CorpList  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"CORP-LIST-N") != null) {
            list = (List)this.redisTemplate.opsForValue().get((Object)"CORP-LIST-N");
            this.logger.info("------------  redisTemplate\u91cc\u6709CorpList ,size: ------------" + list.size());
        } else {
            list = this.corpTreeService.queryNCCoprTreeList();
            if (list != null) {
                this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6CorpList\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01size: " + list.size() + "  ------------");
                this.redisTemplate.opsForValue().set((Object)"CORP-LIST-N", (Object)list, 86400L, TimeUnit.SECONDS);
            }
        }
        return list;
    }

    private List<CorpDeptPath> getCorpDeptList(QueryWrapper queryWrapper) {
        List list = null;
        this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6CorpDeptPathList  ------------");
        if (this.redisTemplate.opsForValue().get((Object)"CORP-DEPT-LIST-N") != null) {
            list = (List)this.redisTemplate.opsForValue().get((Object)"CORP-DEPT-LIST-N");
            this.logger.info("------------  redisTemplate\u91cc\u6709CorpDeptPathList ,size: ------------" + list.size());
        } else {
            list = ((CorpDeptPathMapper)this.baseMapper).selectListAll(queryWrapper);
            if (list != null) {
                this.logger.info("------------  \u5f00\u59cb\u83b7\u53d6CorpDeptPathList\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01size: " + list.size() + "  ------------");
                this.redisTemplate.opsForValue().set((Object)"CORP-DEPT-LIST-N", (Object)list, 86400L, TimeUnit.SECONDS);
            }
        }
        return list;
    }
}

