package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.service.ICtplanBService;
import com.ejianc.business.dataexchange.service.ICtplanService;
import com.ejianc.business.dataexchange.vo.Ctplan;
import com.ejianc.business.dataexchange.vo.CtplanB;
import com.ejianc.business.dataexchange.vo.CtplanCtrVO;
import com.ejianc.business.dataexchange.vo.CtplanCtrlQueryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@RestController
@RequestMapping("/api/")
public class CtplanApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ICtplanService ctplanService;

    @Autowired
    private ICtplanBService ctplanBService;

    /**
     * NC消耗材总控表头同步查询
     * @return
     */
    @GetMapping(value = "/ctplan/list")
    public CommonResponse<List<Ctplan>> queryNCCtPlanlByTs(@RequestParam(required = true, value = "ts") String ts) {
        List<Ctplan> ctplans = ctplanService.queryNCCtPlanlByTs(ts);
        return CommonResponse.success("查询消耗材总控同步数据成功！", ctplans);
    }

    /**
     * NC消耗材总控表体同步查询
     * @return
     */
    @GetMapping(value = "/ctplan/detailList")
    public CommonResponse<List<CtplanB>> queryNCCtPlanDetailByTs(@RequestParam(required = true, value = "ts") String ts) {
        List<CtplanB> ctplanBS = ctplanBService.queryNCCtPlanDetailByTs(ts);
        return CommonResponse.success("查询消耗材总控基本档案同步数据成功！", ctplanBS);
    }

    /**
     * NC消耗材总控计划初始化，放redis里
     * @return
     */
    @GetMapping(value = "/ctplan/redisByOrgList")
    public CommonResponse<String> redisByOrgList(@RequestParam(required = false, value = "beginTime") String beginTime, @RequestParam(required = false,value = "endTime") String endTime,
                                                 @RequestParam(required = false, value = "tenantId") String tenantId, @RequestParam(required = false, value = "pkCorp") String pkCorp){
        return ctplanBService.redisByOrgList(beginTime, endTime, tenantId, pkCorp);
    }

    /**
     * NC总控控制信息查询
     * @return
     */
    @RequestMapping(value = "/ctplan/queryNCCtPlanCtrl", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<CtplanCtrVO>> queryNCCtPlanCtrl(@RequestBody CtplanCtrlQueryVO queryVO){
        return CommonResponse.success("NC总控控制信息查询成功！", ctplanService.queryNCCtPlanCtrl(queryVO));
    }
}
