package com.ejianc.business.dataexchange.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.service.IFeebasicService;
import com.ejianc.business.dataexchange.vo.FeebasicVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@RestController
@RequestMapping("/api/")
public class FeebasicApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFeebasicService feebasicService;


    @RequestMapping(value = "queryFeebasicRef", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FeebasicVO>> queryOthfeeRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("vname");
        fuzzyFields.add("vcode");

        Page<FeebasicVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<FeebasicVO> listres = feebasicService.queryFeebasicRef(page,wrapper);
        IPage<FeebasicVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
