package com.ejianc.business.dataexchange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.InvmanMapper;
import com.ejianc.business.dataexchange.service.IInvmanService;
import com.ejianc.business.dataexchange.vo.Invman;
import com.ejianc.business.fbxt.comment.api.IMatSyncRecordApi;
import com.ejianc.business.fbxt.comment.vo.MatSyncRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 * 物料管理档案接口 服务实现类
 * </p>
 *
 * @author Brin
 * @since 2020-11-04 15:59:15
 */
@Service("invmanService")
public class InvmanService extends ServiceImpl<InvmanMapper, Invman> implements IInvmanService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private IMatSyncRecordApi matSyncRecordApi;

    @Override
    public List<Invman> selectListAll(String ts, String pkCorp) {
        List<Invman> invmanList = baseMapper.queryNCInmansByTs(ts, pkCorp);
        /**
         *  判断物料同步数是否超过10000，若超过，则存在新成立公司，须手动同步新成立物料
         */
        List<Invman> newList = new ArrayList<Invman>();
        if (invmanList.size() > 10000) {
            List<String> corpList = baseMapper.queryManCorpByTs(ts, pkCorp);
            for (String corp : corpList) {
                List<Invman> list = baseMapper.queryNCInmansByTs(ts, corp);
                if (list.size() > 10000) {
                    logger.info("-------> queryNCInmansByTs  Too many material, larger than 10000 ! ");
                    continue;
                } else {
                    newList.addAll(list);
                }
            }
        } else {
            newList.addAll(invmanList);
        }
        return newList;
    }

    @Override
    public List<Invman> selectListAllByQj(String beginTime, String endTime, Integer beginRow, Integer endRow, String pkCorp) {
        return baseMapper.queryNCInmansByQj(beginTime, endTime, beginRow, endRow, pkCorp);
    }

    @Override
    public CommonResponse<String> redisByOrgList(String beginTime, String endTime,  String tenantId, String pkCorp) {
        logger.info("pkCorp is " + pkCorp + StringUtils.isNotBlank(pkCorp));
        if (StringUtils.isNotBlank(pkCorp)) {
            List<Invman> invmanList = baseMapper.queryInmansByQj(beginTime, endTime, pkCorp);
            if(CollectionUtils.isNotEmpty(invmanList)){
                /**
                 *  判断物料同步数是否超过10000，若超过，则存在新成立公司，须手动同步新成立物料
                 */
                if (invmanList.size() > 10000) {
                    logger.info("-------> queryInmansByQj  Too many material, larger than 10000 ! ");
                    return CommonResponse.success("该公司本次同步数量超过10000条！");
                } else {
                    String json = JSONObject.toJSONString(invmanList);
                    logger.info("put redis is " + pkCorp + " invmanList size is " + invmanList.size());
                    redisTemplate.opsForValue().set(pkCorp + "@@@&&&", json,6000, TimeUnit.SECONDS);
                }
            }
        }else{
            List<MatSyncRecordVO> syncList = new ArrayList<>();
            List<Invman> list = baseMapper.queryInmansCount(beginTime, endTime);
            logger.info("before put time is " + new Date());
            if(CollectionUtils.isNotEmpty(list)) {
                for (Invman invman : list) {
                    /**
                     *  判断物料同步数是否超过10000，若超过，则存在新成立公司，须手动同步新成立物料
                     */
                    if (invman.getNum() > 10000) {
                        logger.info("-------> queryInmansByQj  Too many material, larger than 10000 ! " + invman.getPkcorp());
                        MatSyncRecordVO recordVO = new MatSyncRecordVO();
                        recordVO.setPkCorp(invman.getPkcorp());
                        recordVO.setNum(invman.getNum());
                        recordVO.setBeginTime(beginTime);
                        recordVO.setEndTime(endTime);
                        recordVO.setSyncFlag(0);
                        syncList.add(recordVO);
                    }else {
                        List<Invman> invmanList = baseMapper.queryInmansByQj(beginTime, endTime, invman.getPkcorp());
                        String json = JSONObject.toJSONString(invmanList);
                        logger.info("put redis is " + invman.getPkcorp() + " invmanList size is " + invmanList.size());
                        redisTemplate.opsForValue().set(invman.getPkcorp() + "@@@&&&", json,6000, TimeUnit.SECONDS);
                    }
                }
                if (CollectionUtils.isNotEmpty(syncList)) {
                    CommonResponse<String> response = matSyncRecordApi.insertBatch(syncList);
                    if (!response.isSuccess()) {
                        logger.info("insert record result is " + JSONObject.toJSONString(response));
                    }
                }
            }
            logger.info("end put time is " + new Date());
        }
       return CommonResponse.success("redis物料管理档案同步数据成功！");
    }


}

