package com.ejianc.business.dataexchange.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.CmContractInfoMapper;
import com.ejianc.business.dataexchange.service.ICmContractInfoService;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.dataexchange.vo.LeaseInfoPriceRecordVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("CmContractInfoService")
public class CmContractInfoService extends ServiceImpl<CmContractInfoMapper, CmContractInfoVO> implements ICmContractInfoService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public List<CmContractInfoVO> querySubContractInfos(Page<CmContractInfoVO> page, QueryWrapper queryWrapper, Long supplierId, String pkContract) {
        List<CmContractInfoVO> list = baseMapper.querySubContractInfoPage(page,queryWrapper,supplierId,pkContract);
        //解决：NC端分包合同多级改造后，历史合同数据找不到清单 brin
//        if(list == null || list.isEmpty()) {
//            list = baseMapper.queryContractInfoPageOld(page,queryWrapper,supplierId,pkContract);
//        }
        return list;
    }

    @Override
    public List<CmContractInfoVO> queryMatContractInfos(Page<CmContractInfoVO> page, QueryWrapper queryWrapper, Long supplierId, String pkContract, String pkProject) {
        List<CmContractInfoVO> list = baseMapper.queryMatContractInfoPage(page,queryWrapper,supplierId,pkContract, pkProject);
        //解决：NC端分包合同多级改造后，历史合同数据找不到清单 brin
//        if(list == null || list.isEmpty()) {
//            list = baseMapper.queryContractInfoPageOld(page,queryWrapper,supplierId,pkContract);
//        }
        return list;
    }

    public List<CmContractInfoVO> queryLeaseContractInfoById(String pkContract) {
        logger.info("------------ service pkContract 合同主键 ,{}",pkContract);
        List<CmContractInfoVO> entity = baseMapper.queryLeaseContractInfoById(pkContract);
        return entity;
    }

    public List<CmContractInfoVO> queryMatContractInfoById(String pkContract) {
        logger.info("------------ service pkContract 物资类合同主键 ,{}",pkContract);
        List<CmContractInfoVO> entity = baseMapper.queryMatContractInfoById(pkContract);
        return entity;
    }

    @Override
    public List<LeaseInfoPriceRecordVO> queryLeasePriceById(String pkContract, String pkContractInfo) {
        logger.info("------------ service pkContract 周转材合同主键 ,{}",pkContract);
        logger.info("------------ service pkContract 周转材合同主键 ,{}",pkContractInfo);
        return baseMapper.queryLeasePriceById(pkContract, pkContractInfo);
    }

    @Override
    public List<CmContractInfoVO> queryLeaseContractInfos(Page<CmContractInfoVO> page, QueryWrapper wrapper, String pkContract, String pkProject) {
        List<CmContractInfoVO> list = baseMapper.queryLeaseContractInfoPage(page,wrapper,pkContract, pkProject);
        return list;
    }
}
