/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.service.ICmContractInfoService;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"contractinfo"})
public class CmContractInfoController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICmContractInfoService cmContractInfoService;
    @Autowired
    private IMaterialApi materialApi;

    @RequestMapping(value={"queryCmContractInfoRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CmContractInfoVO>> querySubCmContractInfoRef(@RequestParam(value="pkContract", required=false) String pkContract, @RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("infocode");
        fuzzyFields.add("infoname");
        Long supplierId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)JSON.parse((String)condition).toString(), Map.class);
            if (null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                this.logger.info("\u53c2\u6570supplierId--" + supplierId);
            }
            if (null != conditionMap.get("pkContract")) {
                pkContract = conditionMap.get("pkContract").toString();
                this.logger.info("\u53c2\u6570pkContract--" + pkContract);
            }
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<CmContractInfoVO> listres = this.cmContractInfoService.querySubContractInfos((Page<CmContractInfoVO>)page, wrapper, supplierId, pkContract);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"queryMatContractInfoRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CmContractInfoVO>> queryMatContractInfoRef(@RequestParam(value="pkContract", required=false) String pkContract, @RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("infocode");
        fuzzyFields.add("infoname");
        Long supplierId = null;
        String pkProject = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("supplierId")) {
                supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                this.logger.info("\u53c2\u6570supplierId--" + supplierId);
            }
            if (null != conditionMap.get("pkContract")) {
                pkContract = conditionMap.get("pkContract").toString();
                this.logger.info("\u53c2\u6570pkContract--" + pkContract);
            }
            if (null != conditionMap.get("pkProject")) {
                pkProject = conditionMap.get("pkProject").toString();
                this.logger.info("\u53c2\u6570pkProject--" + pkProject);
            }
        }
        if (pkProject == null) {
            throw new BusinessException("\u81ea\u5efa\u9879\u76ee\u65e0\u6cd5\u5173\u8054\u5408\u540c\uff01");
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<CmContractInfoVO> listres = this.cmContractInfoService.queryMatContractInfos((Page<CmContractInfoVO>)page, wrapper, supplierId, pkContract, pkProject);
        for (CmContractInfoVO cmContractInfoVO : listres) {
            CommonResponse matRes = this.materialApi.queryMaterialBySourceId(cmContractInfoVO.getPkInvbasdoc());
            if (!matRes.isSuccess()) continue;
            MaterialVO materialVO = (MaterialVO)matRes.getData();
            cmContractInfoVO.setMaterialId(materialVO.getId());
            cmContractInfoVO.setMaterialTypeId(materialVO.getCategoryId());
            cmContractInfoVO.setMaterialTypeName(materialVO.getCategoryName());
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"queryLeaseContractInfoRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CmContractInfoVO>> queryLeaseContractInfoRef(@RequestParam(value="pkContract", required=false) String pkContract, @RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("infocode");
        fuzzyFields.add("infoname");
        String pkProject = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("pkContract")) {
                pkContract = conditionMap.get("pkContract").toString();
                this.logger.info("\u53c2\u6570pkContract--" + pkContract);
            }
            if (null != conditionMap.get("pkProject")) {
                pkProject = conditionMap.get("pkProject").toString();
                this.logger.info("\u53c2\u6570pkProject--" + pkProject);
            }
        }
        if (pkProject == null) {
            throw new BusinessException("\u81ea\u5efa\u9879\u76ee\u65e0\u6cd5\u5173\u8054\u5408\u540c\uff01");
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<CmContractInfoVO> listres = this.cmContractInfoService.queryLeaseContractInfos((Page<CmContractInfoVO>)page, wrapper, pkContract, pkProject);
        for (CmContractInfoVO cmContractInfoVO : listres) {
            CommonResponse matRes;
            if (cmContractInfoVO.getPkInvbasdoc() != null) {
                matRes = this.materialApi.queryMaterialBySourceId(cmContractInfoVO.getPkInvbasdoc());
                if (!matRes.isSuccess()) continue;
                MaterialVO materialVO = (MaterialVO)matRes.getData();
                cmContractInfoVO.setMaterialId(materialVO.getId());
                cmContractInfoVO.setMaterialTypeId(materialVO.getCategoryId());
                cmContractInfoVO.setMaterialTypeName(materialVO.getCategoryName());
                continue;
            }
            if (cmContractInfoVO.getPkInvcl() == null || !(matRes = this.materialApi.queryCategoryBySourceId(cmContractInfoVO.getPkInvcl())).isSuccess()) continue;
            MaterialCategoryVO materialCategoryVO = (MaterialCategoryVO)matRes.getData();
            cmContractInfoVO.setMaterialTypeId(materialCategoryVO.getId());
            cmContractInfoVO.setMaterialTypeName(materialCategoryVO.getName());
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"queryLeaseContractInfoById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CmContractInfoVO>> queryLeaseContractInfoById(String pkContract) {
        this.logger.info("\u4f20\u5165\u53c2\u6570\u5408\u540c\u4e3b\u952e --pkContract---: {}", (Object)pkContract);
        List<CmContractInfoVO> entity = this.cmContractInfoService.queryLeaseContractInfoById(pkContract);
        for (CmContractInfoVO cmContractInfoVO : entity) {
            CommonResponse matRes;
            if (cmContractInfoVO.getPkInvbasdoc() != null) {
                matRes = this.materialApi.queryMaterialBySourceId(cmContractInfoVO.getPkInvbasdoc());
                if (!matRes.isSuccess()) continue;
                MaterialVO materialVO = (MaterialVO)matRes.getData();
                cmContractInfoVO.setMaterialId(materialVO.getId());
                cmContractInfoVO.setMaterialTypeId(materialVO.getCategoryId());
                cmContractInfoVO.setMaterialTypeName(materialVO.getCategoryName());
                continue;
            }
            if (cmContractInfoVO.getPkInvcl() == null || !(matRes = this.materialApi.queryCategoryBySourceId(cmContractInfoVO.getPkInvcl())).isSuccess()) continue;
            MaterialCategoryVO materialCategoryVO = (MaterialCategoryVO)matRes.getData();
            cmContractInfoVO.setMaterialTypeId(materialCategoryVO.getId());
            cmContractInfoVO.setMaterialTypeName(materialCategoryVO.getName());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u6e05\u5355\u5217\u8868\u5b9e\u4f53\u6210\u529f\uff01", entity);
    }

    @RequestMapping(value={"queryMatContractInfoById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CmContractInfoVO>> queryMatContractInfoById(String pkContract) {
        this.logger.info("\u4f20\u5165\u7269\u8d44\u53c2\u6570\u5408\u540c\u4e3b\u952e --pkContract---: {}", (Object)pkContract);
        List<CmContractInfoVO> entity = this.cmContractInfoService.queryMatContractInfoById(pkContract);
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u6e05\u5355\u5217\u8868\u5b9e\u4f53\u6210\u529f\uff01", entity);
    }
}

