/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataexchange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ejianc.business.dataexchange.mapper.InvmanMapper;
import com.ejianc.business.dataexchange.service.IInvmanService;
import com.ejianc.business.dataexchange.vo.Invman;
import com.ejianc.business.fbxt.comment.api.IMatSyncRecordApi;
import com.ejianc.business.fbxt.comment.vo.MatSyncRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="invmanService")
public class InvmanService
extends ServiceImpl<InvmanMapper, Invman>
implements IInvmanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IMatSyncRecordApi matSyncRecordApi;

    @Override
    public List<Invman> selectListAll(String ts, String pkCorp) {
        List<Invman> invmanList = ((InvmanMapper)this.baseMapper).queryNCInmansByTs(ts, pkCorp);
        ArrayList<Invman> newList = new ArrayList<Invman>();
        if (invmanList.size() > 10000) {
            List<String> corpList = ((InvmanMapper)this.baseMapper).queryManCorpByTs(ts, pkCorp);
            for (String corp : corpList) {
                List<Invman> list = ((InvmanMapper)this.baseMapper).queryNCInmansByTs(ts, corp);
                if (list.size() > 10000) {
                    this.logger.info("-------> queryNCInmansByTs  Too many material, larger than 10000 ! ");
                    continue;
                }
                newList.addAll(list);
            }
        } else {
            newList.addAll(invmanList);
        }
        return newList;
    }

    @Override
    public List<Invman> selectListAllByQj(String beginTime, String endTime, Integer beginRow, Integer endRow, String pkCorp) {
        return ((InvmanMapper)this.baseMapper).queryNCInmansByQj(beginTime, endTime, beginRow, endRow, pkCorp);
    }

    @Override
    public CommonResponse<String> redisByOrgList(String beginTime, String endTime, String tenantId, String pkCorp) {
        this.logger.info("pkCorp is " + pkCorp + StringUtils.isNotBlank((CharSequence)pkCorp));
        if (StringUtils.isNotBlank((CharSequence)pkCorp)) {
            List<Invman> invmanList = ((InvmanMapper)this.baseMapper).queryInmansByQj(beginTime, endTime, pkCorp);
            if (CollectionUtils.isNotEmpty(invmanList)) {
                if (invmanList.size() > 10000) {
                    this.logger.info("-------> queryInmansByQj  Too many material, larger than 10000 ! ");
                    return CommonResponse.success((String)"\u8be5\u516c\u53f8\u672c\u6b21\u540c\u6b65\u6570\u91cf\u8d85\u8fc710000\u6761\uff01");
                }
                String json = JSONObject.toJSONString(invmanList);
                this.logger.info("put redis is " + pkCorp + " invmanList size is " + invmanList.size());
                this.redisTemplate.opsForValue().set((Object)(pkCorp + "@@@&&&"), (Object)json, 6000L, TimeUnit.SECONDS);
            }
        } else {
            ArrayList<MatSyncRecordVO> syncList = new ArrayList<MatSyncRecordVO>();
            List<Invman> list = ((InvmanMapper)this.baseMapper).queryInmansCount(beginTime, endTime);
            this.logger.info("before put time is " + new Date());
            if (CollectionUtils.isNotEmpty(list)) {
                CommonResponse response;
                for (Invman invman : list) {
                    if (invman.getNum() > 10000) {
                        this.logger.info("-------> queryInmansByQj  Too many material, larger than 10000 ! " + invman.getPkcorp());
                        MatSyncRecordVO recordVO = new MatSyncRecordVO();
                        recordVO.setPkCorp(invman.getPkcorp());
                        recordVO.setNum(invman.getNum());
                        recordVO.setBeginTime(beginTime);
                        recordVO.setEndTime(endTime);
                        recordVO.setSyncFlag(Integer.valueOf(0));
                        syncList.add(recordVO);
                        continue;
                    }
                    List<Invman> invmanList = ((InvmanMapper)this.baseMapper).queryInmansByQj(beginTime, endTime, invman.getPkcorp());
                    String json = JSONObject.toJSONString(invmanList);
                    this.logger.info("put redis is " + invman.getPkcorp() + " invmanList size is " + invmanList.size());
                    this.redisTemplate.opsForValue().set((Object)(invman.getPkcorp() + "@@@&&&"), (Object)json, 6000L, TimeUnit.SECONDS);
                }
                if (CollectionUtils.isNotEmpty(syncList) && !(response = this.matSyncRecordApi.insertBatch(syncList)).isSuccess()) {
                    this.logger.info("insert record result is " + JSONObject.toJSONString((Object)response));
                }
            }
            this.logger.info("end put time is " + new Date());
        }
        return CommonResponse.success((String)"redis\u7269\u6599\u7ba1\u7406\u6863\u6848\u540c\u6b65\u6570\u636e\u6210\u529f\uff01");
    }
}

